

<?php if(isset($category_id)): ?>
    <?php
        $category_search = $category;
        $meta_title = $category->meta_title;
        $meta_description = $category->meta_description;
        $meta_keywords = $category->meta_keywords;
    ?>
<?php elseif(isset($brand_id)): ?>
    <?php
        $brand_name = get_single_brand($brand_id)->name;
        $meta_title = get_single_brand($brand_id)->meta_title;
        $meta_description = get_single_brand($brand_id)->meta_description;
        $meta_keywords = get_single_brand($brand_id)->meta_keywords;
    ?>
<?php else: ?>
    <?php
        $meta_title = get_setting('meta_title');
        $meta_description = get_setting('meta_description');
    ?>
<?php endif; ?>

<?php $__env->startSection('meta_title'); ?><?php echo e($meta_title); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?><?php echo e($meta_description); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?><?php echo e($meta_keywords ?? ''); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="<?php echo e($meta_title); ?>">
    <meta itemprop="description" content="<?php echo e($meta_description); ?>">

    <!-- Twitter Card data -->
    <meta name="twitter:title" content="<?php echo e($meta_title); ?>">
    <meta name="twitter:description" content="<?php echo e($meta_description); ?>">

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($meta_title); ?>" />
    <meta property="og:description" content="<?php echo e($meta_description); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="mb-1">
        <div class="container sm-px-0 pt-1">
            <form class="" id="search-form" action="" method="GET">
                <div class="row">

                    <!-- Sidebar Filters -->
                    <div class="col-xl-3">
                        <div class="aiz-filter-sidebar collapse-sidebar-wrap sidebar-xl sidebar-right z-1035">
                            <div class="overlay overlay-fixed dark c-pointer" data-toggle="class-toggle"
                                data-target=".aiz-filter-sidebar" data-same=".filter-sidebar-thumb"></div>
                            <div class="collapse-sidebar scroll-bar-show c-scrollbar-light text-left">
                                <div class="d-flex d-xl-none justify-content-between align-items-center pl-3 border-bottom">
                                    <h3 class="h6 mb-0 fw-600"><?php echo e(translate('Filters')); ?></h3>
                                    <button type="button" class="btn btn-sm p-2 filter-sidebar-thumb"
                                        data-toggle="class-toggle" data-target=".aiz-filter-sidebar">
                                        <i class="las la-times la-2x"></i>
                                    </button>
                                </div>

                                <!-- Categories -->
                                <div class="bg-white border-bottom-listing-sidebar">
                                    <div class="fs-16 fw-700 p-3">
                                        <a href="#collapse_1"
                                            class="dropdown-toggle filter-section text-dark d-flex align-items-center justify-content-between"
                                            data-toggle="collapse">

                                            <?php echo e(translate('Categories')); ?>

                                        </a>
                                    </div>
                                    <div class="collapse show" id="collapse_1">
                                        <!-- Product Category -->
                                        <div class="">
                                            <div class=" <?php if($errors->has('category_ids') || $errors->has('category_id')): ?> border border-danger <?php endif; ?>">
                                                <?php
                                                    if ($category_id) {
                                                        $old_categories = [$category_id];
                                                    } else {
                                                        $old_categories = [];
                                                    }
                                                ?>
                                                
                                                <div class="px-20px pb-10px display-none" id="general_cagegories_box">
                                                    <div id="category_filter" class="h-300px overflow-auto no-scrollbar">
                                                        <ul class="hummingbird-treeview-converter2 list-unstyled"
                                                            data-checkbox-name="categories[]">
                                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                
                                                                <li d-item="<?php echo e($category->products_count); ?>"
                                                                    id="generel_<?php echo e($category->id); ?>">
                                                                    <?php echo e($category->getTranslation('name')); ?>

                                                                    <?php if($category->products_count > 0): ?>
                                                                        <?php echo e('   (' . $category->products_count . ')'); ?>

                                                                    <?php endif; ?>
                                                                </li>
                                                                
                                                                <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo $__env->make(
                                                                        'frontend.product_listing_page_child_category',
                                                                        ['child_category' => $childCategory]
                                                                    , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>

                                                
                                                <div class="px-20px pb-10px display-none" id="preorder_cagegories_box">
                                                    <div id="category_filter_preorder"
                                                        class="h-300px overflow-auto no-scrollbar">
                                                        <ul class="hummingbird-treeview-converter2 list-unstyled"
                                                            data-checkbox-name="categories_preorder[]">
                                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($category->products_count > 0): ?>
                                                                    <li d-item="<?php echo e($category->products_count); ?>"
                                                                        id="preorder_<?php echo e($category->id); ?>">
                                                                        <?php echo e($category->getTranslation('name')); ?><?php echo e('   (' . $category->products_count . ')'); ?>

                                                                    </li>
                                                                <?php endif; ?>
                                                                <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo $__env->make(
                                                                        'frontend.product_listing_page_child_category_preorder',
                                                                        ['child_category' => $childCategory]
                                                                    , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <!-- Price range -->
                                <div class="bg-white border-bottom-listing-sidebar">
                                    <div class="fs-16 fw-700 p-3">
                                        <a href="#collapse_price"
                                            class="dropdown-toggle collapsed filter-section text-dark d-flex align-items-center justify-content-between"
                                            data-toggle="collapse"
                                            data-target="#collapse_price">
                                            <?php echo e(translate('Price range')); ?>

                                        </a>
                                    </div>
                                    <div class="collapse" id="collapse_price">
                                        <div class="px16px py22px hover-effect">
                                            <?php
                                                $product_count = get_products_count();
                                            ?>

                                            <div class="aiz-range-slider">


                                                <div id="input-slider-range"
                                                    data-range-value-min="<?php if(true): ?> 0 <?php else: ?> <?php echo e(get_product_min_unit_price()); ?> <?php endif; ?>"
                                                    data-range-value-max="<?php if($product_count < 1): ?> 0 <?php else: ?> <?php echo e(get_product_max_unit_price()); ?> <?php endif; ?>">
                                                    <div
                                                        style="width: 4px; height: 16px; background-color: #DFDFE6; position: absolute; top: -7px; left: -1px;  ">
                                                    </div>
                                                    <div
                                                        style="width: 4px; height: 16px; background-color: #DFDFE6; position: absolute; top: -7px; right: -1px;  ">
                                                    </div>
                                                </div>

                                                <div class="row mt-2">
                                                    <div class="col-6">
                                                        <span class="range-slider-value value-low fs-14 fw-600 opacity-70"
                                                             data-range-value-low="0"
                                                             id="input-slider-range-value-low">0</span>
                                                    </div>
                                                    <div class="col-6 text-right">
                                                        <span class="range-slider-value value-high fs-14 fw-600 opacity-70"
                                                            
                                                            data-range-value-high="<?php echo e(get_product_max_unit_price() / 2); ?>"
                                                             id="input-slider-range-value-high"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Hidden Items -->
                                        <input type="hidden" name="min_price" value="">
                                        <input type="hidden" name="max_price" value="">
                                    </div>
                                </div>


                                <!-- Attributes -->
                                <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($attribute->product_count > 0): ?>
                                        <div class="bg-white preorder-time-hide border-bottom-listing-sidebar">
                                            <div class="fs-16 fw-700 p-3">
                                                <a href="#"
                                                    class="dropdown-toggle text-dark filter-section collapsed d-flex align-items-center justify-content-between"
                                                    data-toggle="collapse"
                                                    data-target="#collapse_<?php echo e(str_replace(' ', '_', preg_replace('/[^a-zA-Z]/', '', $attribute->name))); ?>"
                                                    style="white-space: normal;">
                                                    <?php echo e($attribute->getTranslation('name')); ?>

                                                </a>
                                            </div>
                                            <?php
                                                $show = '';
                                                foreach ($attribute->attribute_values as $attribute_value) {
                                                    if (in_array($attribute_value->value, $selected_attribute_values)) {
                                                        $show = 'show';
                                                    }
                                                }
                                            ?>
                                            <div class="collapse <?php echo e($show); ?>"
                                                id="collapse_<?php echo e(str_replace(' ', '_', preg_replace('/[^a-zA-Z]/', '', $attribute->name))); ?>">
                                                <div class="px-3 aiz-checkbox-list">
                                                    <?php $__currentLoopData = $attribute->attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($attribute_value->product_count > 0): ?>
                                                            <label class="aiz-checkbox mb-3 d-flex align-items-center ">
                                                                <input type="checkbox" name="selected_attribute_values[]"
                                                                    value="<?php echo e($attribute_value->value); ?>"
                                                                    <?php if(in_array($attribute_value->value, $selected_attribute_values)): ?> checked <?php endif; ?>
                                                                    onchange="filter(event)">
                                                                <span class="aiz-square-check border_black"></span>
                                                                <span
                                                                    class="fs-14 fw-400 text-dark hover-effect-list-item  <?php if(in_array($attribute_value->value, $selected_attribute_values)): ?> fw-bold <?php endif; ?>"><?php echo e($attribute_value->value); ?>

                                                                    <?php echo e('(' . $attribute_value->product_count . ')'); ?></span>
                                                            </label>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                                <div class="d-flex justify-content-end">
                                                    <button type="button"
                                                        class="btn btn-link p-0 m-0 mb-3 font-weight-bold see_more_toggle_btn">
                                                        See More <i class="las la-angle-down fs-12 fw-600 "></i></button>
                                                </div>
                                                <div class="d-flex justify-content-end">
                                                    <button type="button"
                                                        class="btn btn-link p-0 m-0 mb-3 font-weight-bold less_toggle_btn">See
                                                        Less <i class="las la-angle-up fs-12 fw-600 "></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <!-- Color -->
                                <?php if(get_setting('color_filter_activation')): ?>
                                    <div class="bg-white  mb-3 preorder-time-hide">
                                        <div class="fs-16 fw-700 p-3">
                                            <a href="#"
                                                class="dropdown-toggle text-dark filter-section collapsed d-flex align-items-center justify-content-between"
                                                data-toggle="collapse" data-target="#collapse_color">
                                                <?php echo e(translate('Filter by color')); ?>

                                            </a>
                                        </div>
                                        <?php
                                            $show = '';
                                            foreach ($colors as $key => $color) {
                                                if (isset($selected_color) && $selected_color == $color->code) {
                                                    $show = 'show';
                                                }
                                            }
                                        ?>
                                        <div class="collapse <?php echo e($show); ?>" id="collapse_color">
                                            <div class="px-3 aiz-checkbox-list">
                                                <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($color->product_count > 0): ?>
                                                        <label class="aiz-checkbox mb-3 d-flex align-items-center ">
                                                            <input type="checkbox" name="colors[]"
                                                                value="<?php echo e($color->code); ?>"
                                                                <?php if(isset($selected_color) && $selected_color == $color->code): ?> checked <?php endif; ?>
                                                                onchange="filter(event)">
                                                            <span class="aiz-square-check border_black"></span>
                                                            <div class="d-flex">

                                                                <div
                                                                    style="width: 20px; height: 20px; background-color: <?php echo e($color->code); ?>;border-radius: 50%; margin-right: 10px;">
                                                                </div>
                                                                <span
                                                                    class="fs-14 text-dark hover-effect-list-item"><?php echo e($color->name); ?>

                                                                    <?php echo e('(' . $color->product_count . ')'); ?>

                                                                </span>
                                                            </div>
                                                        </label>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <div class="d-flex justify-content-end">
                                                <button type="button"
                                                    class="btn btn-link p-0 m-0 mb-3 font-weight-bold see_more_toggle_btn">
                                                    See More <i class="las la-angle-down fs-12 fw-600 "></i></button>
                                            </div>
                                            <div class="d-flex justify-content-end">
                                                <button type="button"
                                                    class="btn btn-link p-0 m-0 mb-3 font-weight-bold less_toggle_btn">See
                                                    Less <i class="las la-angle-up fs-12 fw-600 "></i></button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!-- Attributes for preorder product -->
                                <div
                                    class="bg-white  mb-3 mt-3 preorder-time-show display-none border-bottom-listing-sidebar">
                                    <div class="fs-16 fw-700 p-3">
                                        <a href="#"
                                            class="dropdown-toggle text-dark filter-section collapsed d-flex align-items-center justify-content-between"
                                            data-toggle="collapse" data-target="#collapse_availability_filter"
                                            style="white-space: normal;">
                                            <?php echo e(translate('Filter by Availability')); ?>

                                        </a>
                                    </div>
                                    <?php
                                        $show = $is_available !== null ? 'show' : '';
                                    ?>
                                    <div class="collapse <?php echo e($show); ?>" id="collapse_availability_filter">
                                        <div class="p-3 aiz-checkbox-list">
                                            <label class="aiz-checkbox mb-3">
                                                <input type="radio" name="is_available" value="1"
                                                    <?php if($is_available == 1): ?> checked <?php endif; ?>
                                                    onchange="filter(event)">
                                                <span class="aiz-square-check border_black"
                                                    style="--primary: var(--black-50);"></span>
                                                <span
                                                    class="fs-14 fw-400 text-dark hover-effect-list-item"><?php echo e(translate('Available Now')); ?></span>
                                            </label>
                                            <label class="aiz-checkbox mb-3">
                                                <input type="radio" name="is_available" value="0"
                                                    <?php if($is_available === '0'): ?> checked <?php endif; ?>
                                                    onchange="filter(event)">
                                                <span class="aiz-square-check border_black"></span>
                                                <span
                                                    class="fs-14 fw-400 text-dark hover-effect-list-item"><?php echo e(translate('Upcoming')); ?></span>
                                            </label>
                                            <label class="aiz-checkbox mb-3">
                                                <input type="radio" name="is_available" value=""
                                                    <?php if($is_available === null): ?> checked <?php endif; ?>
                                                    onchange="filter(event)">
                                                <span class="aiz-square-check border_black"></span>
                                                <span
                                                    class="fs-14 fw-400 text-dark hover-effect-list-item"><?php echo e(translate('All')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>




                            </div>
                        </div>
                    </div>

                    <!-- Contents -->
                    <div class="col-xl-9">
                        <?php if(addon_is_activated('preorder') && Route::currentRouteName() == 'search'): ?>
                            <div class="product-tab mt-2">
                                <?php
                                    $activeClasses = 'bg-soft-dark text-white';
                                    $inActiveClasses = 'preorder-border-dashed  text-muted  fw-600';
                                ?>
                                <div class="p-0 aiz-radio-inline">
                                    <label class="aiz-megabox pl-0 mr-2 " data-toggle="tooltip"
                                        data-title="<?php echo e(translate('General Products')); ?>">
                                        <input type="radio" name="product_type" value="general_product"
                                            onchange="filter(event)" <?php if(isset($product_type) && $product_type == 'general_product'): ?> checked <?php endif; ?>>
                                        <span id="product_type_badge_general"
                                            class="badge badge-inline fs-12 p-3 rounded-3 ">
                                            <?php echo e(translate('General Products')); ?>

                                            <span class="badge badge-inline bg-soft-dark fs-12  p-1 rounded-3 text-white"
                                                style="background: <?php echo e(translate('General Products')); ?>;"></span>
                                        </span>
                                    </label>
                                    <label class="aiz-megabox pl-0 " data-toggle="tooltip"
                                        data-title="<?php echo e(translate('Preorder Products')); ?>">
                                        <input type="radio" name="product_type" value="preorder_product"
                                            onchange="filter(event)" <?php if(isset($product_type) && $product_type == 'preorder_product'): ?> checked <?php endif; ?>>
                                        <span id="product_type_badge_preorder"
                                            class="badge badge-inline fs-12 p-3 rounded-3  ">
                                            <?php echo e(translate('Preorder Products')); ?>

                                            <span
                                                class="badge badge-inline bg-soft-dark fs-12  my-2 p-1 rounded-3 text-white"
                                                style="background: <?php echo e(translate('Preorder Products')); ?>;"></span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        <?php endif; ?>
                        <!-- Breadcrumb -->
                        <ul class="breadcrumb mb-0 bg-transparent py-0 px-0 mt-2 d-flex align-items-center">
                            <li class=" has-transition opacity-50 hov-opacity-100">
                                <a class="text-reset" href="<?php echo e(route('home')); ?>"><?php echo e(translate('Home')); ?></a>
                            </li>
                                <?php if(!isset($category_id) && !isset($brand_id)): ?>
                                    <i class="las la-angle-right fs-12 fw-600"></i>
                                    <li class=" fw-700  text-dark fs-12">
                                        "<?php echo e(translate('All Categories')); ?>"
                                    </li>
                                <?php else: ?>

                                <i class="las la-angle-right fs-12 fw-600 show_cat1 d-none"></i>
                                <li class=" fw-700  text-dark fs-12 show_cat1 d-none">
                                    "<?php echo e(translate('All Categories')); ?>"
                                </li>

                                <?php if(!isset($brand_id)): ?>

                                <i class="las la-angle-right fs-12 fw-600 hide_cat1"></i>
                                <li class=" opacity-50 hov-opacity-100 fs-12 hide_cat1">
                                    <a class="text-reset"
                                        href="<?php echo e(route('search')); ?>"><?php echo e(translate('All Categories')); ?></a>
                                </li>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if(isset($brand_id)): ?>
                                <i class="las la-angle-right fs-12 fw-600 hide_cat1 "></i>
                                <li class=" fw-700  text-dark opacity-50 hov-opacity-100 fs-12 hide_cat1">
                                    <?php echo e(translate('Brand')); ?>

                                </li>

                                <i class="las la-angle-right fs-12 fw-600 hide_cat1"></i>
                                <li class=" fw-700  text-dark  fs-12 hide_cat1">
                                    "<?php echo e($brand_name); ?>"
                                </li>
                            <?php endif; ?>
                        
                            <?php if(isset($category_id)): ?>
                                <i class="las la-angle-right fs-12 fw-600 d-flex hide_cat1"></i>
                                <li class="text-dark fw-600 fs-12 hide_cat1">
                                    "<?php echo e($category_search->getTranslation('name')); ?>"
                                </li>
                            <?php endif; ?>
                        </ul>

                        <!-- Top Filters -->
                        <div class="text-left mb-3">
                            <div class="row gutters-5 flex-wrap align-items-center">
                                <div class="col-lg col-10">
                                    <h1 class="fs-18 fs-md-20 fw-700 text-dark line-height_0_7">
                                        <?php if(isset($category_id)): ?>
                                            
                                            <?php echo e(translate('Showing results')); ?>

                                        <?php elseif(isset($query)): ?>
                                            <?php echo e(translate('Search result for ')); ?> "<?php echo e($query); ?>"
                                        <?php else: ?>
                                            <?php echo e(translate('Showing results')); ?>

                                        <?php endif; ?>
                                    </h1>
                                    <div class="fs-12 display-none" id="search_product_count"><span class="fw-bold"
                                            id="total_product_count"><?php echo e($products->total()); ?></span><span
                                            class="product-name-color "> Products Found</span></div>
                                    <div class="display-none fs-12 product-name-color" id="searching_product">searching..
                                    </div>
                                    <input type="hidden" name="keyword" value="<?php echo e($query); ?>">
                                </div>
                                <div class="col-2 col-lg-auto d-xl-none mb-lg-3 text-right">
                                    <button type="button" class="btn btn-icon p-0" data-toggle="class-toggle"
                                        data-target=".aiz-filter-sidebar">
                                        <i class="la la-filter la-2x"></i>
                                    </button>
                                </div>

                                <div class="col-6 col-lg-auto mb-3 w-lg-200px d-flex align-items-center gap-2">
                                    <div id="select_option_svg">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="17.5" height="13.5"
                                            viewBox="0 0 17.5 13.5">
                                            <g id="Group_38743" data-name="Group 38743"
                                                transform="translate(-3444 2590)">
                                                <g id="Group_38742" data-name="Group 38742"
                                                    transform="translate(2089 -2895)">
                                                    <path id="Path_45144" data-name="Path 45144"
                                                        d="M20.522,10.663a.75.75,0,0,1-1.061-.016l-2.712-2.8V18a.75.75,0,0,1-1.5,0V7.851l-2.712,2.8A.75.75,0,1,1,11.462,9.6l4-4.125a.75.75,0,0,1,1.077,0l4,4.125A.75.75,0,0,1,20.522,10.663Z"
                                                        transform="translate(1351.75 299.75)" fill="#aaa"
                                                        fill-rule="evenodd" />
                                                    <path id="Path_45145" data-name="Path 45145"
                                                        d="M12.522,13.337a.75.75,0,0,0-1.061.016l-2.712,2.8V6a.75.75,0,0,0-1.5,0V16.149l-2.712-2.8A.75.75,0,0,0,3.462,14.4l4,4.125a.75.75,0,0,0,1.077,0l4-4.125A.75.75,0,0,0,12.522,13.337Z"
                                                        transform="translate(1351.75 299.75)" fill="#111"
                                                        fill-rule="evenodd" />
                                                    <path id="Path_45144-2" data-name="Path 45144"
                                                        d="M20.522,10.663a.75.75,0,0,1-1.061-.016l-2.712-2.8V18a.75.75,0,0,1-1.5,0V7.851l-2.712,2.8A.75.75,0,1,1,11.462,9.6l4-4.125a.75.75,0,0,1,1.077,0l4,4.125A.75.75,0,0,1,20.522,10.663Z"
                                                        transform="translate(1351.75 299.75)" fill="#aaa"
                                                        fill-rule="evenodd" />
                                                    <path id="Path_45145-2" data-name="Path 45145"
                                                        d="M12.522,13.337a.75.75,0,0,0-1.061.016l-2.712,2.8V6a.75.75,0,0,0-1.5,0V16.149l-2.712-2.8A.75.75,0,0,0,3.462,14.4l4,4.125a.75.75,0,0,0,1.077,0l4-4.125A.75.75,0,0,0,12.522,13.337Z"
                                                        transform="translate(1351.75 299.75)" fill="#111"
                                                        fill-rule="evenodd" />
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <select id="select_option"
                                        class="form-control select_btn_border_none form-control-sm text-center border-0 form-control-sm aiz-selectpicker rounded-0 "
                                        name="sort_by" onchange="filter(event)">
                                        <option value="">
                                            <?php echo e(translate('Sort by')); ?></option>
                                        <option value="newest"
                                            <?php if(isset($sort_by)): ?> <?php if($sort_by == 'newest'): ?> selected <?php endif; ?> <?php endif; ?>>
                                            <?php echo e(translate('Newest')); ?></option>
                                        <option value="oldest"
                                            <?php if(isset($sort_by)): ?> <?php if($sort_by == 'oldest'): ?> selected <?php endif; ?> <?php endif; ?>>
                                            <?php echo e(translate('Oldest')); ?></option>
                                        <option value="price-asc"
                                            <?php if(isset($sort_by)): ?> <?php if($sort_by == 'price-asc'): ?> selected <?php endif; ?> <?php endif; ?>>
                                            <?php echo e(translate('Price low to high')); ?></option>
                                        <option value="price-desc"
                                            <?php if(isset($sort_by)): ?> <?php if($sort_by == 'price-desc'): ?> selected <?php endif; ?> <?php endif; ?>>
                                            <?php echo e(translate('Price high to low')); ?></option>
                                    </select>
                                </div>


                                <div class="d-flex gap-2 mb-3 " style="gap: 8px;">
                                    <button type="button" class="btn-col-filter view-2-hide" data-cols="2">
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                    </button>

                                    <button type="button" class="btn-col-filter view-3-hide"data-cols="3">
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                    </button>

                                    <div class="btn-col-filter view-4-hide" data-cols="4">
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                    </div>

                                    <div class="btn-col-filter view-6-hide" data-cols="6">
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                        <div class="block_btn"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Products -->
                        <div class="px-3">

                            <div class="row gutters-16 row-cols-xxl-4 row-cols-xl-3 row-cols-lg-4 row-cols-md-3 row-cols-2 border-top border-left"
                                id="products-row">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col border-right border-bottom has-transition hov-shadow-out z-1 ">
                                        <?php if(isset($product_type) && $product_type == 'preorder_product'): ?>
                                            <?php echo $__env->make('preorder.frontend.product_box3', [
                                                'product' => $product,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                            <?php echo $__env->make('frontend.product_box_for_listing_page', [
                                                'product' => $product,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="aiz-pagination mt-4" id="pagination"></div>
                    </div>
                </div>
            </form>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">

        let category_page_first_time = true;
        let brand_page_first_time = true;
        function filter(e) {
            // alert("working or not")
            if (e) e.preventDefault();

            const target = e ? e.target : null;

            if (target && target.type === 'checkbox') {
                const parent = target.parentElement;
                if (parent) {
                    const children = parent.children;
                    if (children.length > 0) {
                        const lastSibling = children[children.length - 1];

                        if (target.checked) {
                            lastSibling.classList.add('fw-bold');
                        } else {
                            lastSibling.classList.remove('fw-bold');
                        }
                    }
                }
            }

            filter_data();
        }


        function rangefilter(arg) {
            $('input[name=min_price]').val(arg[0]);
            $('input[name=max_price]').val(arg[1]);
            filter_data();
        }

        function filter_data(page = 1) {
            $("#search_product_count").hide();
            $("#searching_product").show();
            var formData = $('#search-form').serialize();
            formData += '&page=' + page;

            // category filter page some logic here
            let category_id = <?php echo $category_id ?? 'null'; ?>;
            let brand_id = <?php echo $brand_id ?? 'null'; ?>;
            if (category_page_first_time && category_id !== null && category_id !== 0 && category_id !== undefined) {
                formData += '&categories[]=' + category_id;
                category_page_first_time = false;
            }else if(brand_page_first_time && brand_id !== null && brand_id !== 0 && brand_id !== undefined) {
                formData += "&brand_id="+ brand_id;
                brand_page_first_time = false;
            }else {
                $('.hide_cat1').each(function() {
                    this.style.setProperty('display', 'none', 'important');
                });
                $('.show_cat1').removeClass('d-none');
            }

            // alert(formData);

            // product types ways some action this page
            if (formData.includes('product_type=preorder_product')) {
                $('#product_type_badge_preorder').removeClass('preorder-border-dashed my-2 text-muted  fw-600');
                $('#product_type_badge_preorder').addClass('bg-soft-dark  my-2 text-white');
                $('#product_type_badge_general').removeClass('bg-soft-dark my-2  text-white');
                $('#product_type_badge_general').addClass('preorder-border-dashed  text-muted my-2 fw-600');

                $('#preorder_cagegories_box').slideDown(300);
                $('#general_cagegories_box').slideUp(300);

                $('.preorder-time-hide').fadeOut(400);
                $('.preorder-time-show').slideDown(400);
            } else {
                $('#product_type_badge_general').removeClass('preorder-border-dashed my-2  text-muted  fw-600');
                $('#product_type_badge_general').addClass('bg-soft-dark my-2  text-white');
                $('#product_type_badge_preorder').removeClass('bg-soft-dark  my-2 text-white');
                $('#product_type_badge_preorder').addClass('preorder-border-dashed my-2 text-muted  fw-600');

                $('#preorder_cagegories_box').slideUp(300);
                $('#general_cagegories_box').slideDown(300);

                $('.preorder-time-hide').fadeIn(400);
                $('.preorder-time-show').slideUp(400);
            }

            // alert(JSON.stringify(formData));
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('suggestion.search2')); ?>",
                type: 'get',
                data: formData,
                success: function(response) {
                    // alert(JSON.stringify(response))
                    $("#search_product_count").show();
                    $("#searching_product").hide();
                    $('#products-row').html(response.product_html);
                    $('#pagination').html(response.pagination_html);
                    $('#total_product_count').text(response.total_product_count);

                    window.scrollTo({
                        top: 0,
                        behavior: 'smooth'
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                }
            });
        }

        // Handle page button click
        $(document).on('click', '.page-btn', function(e) {
            e.preventDefault();
            var page = $(this).data('page');
            filter_data(page);
        });
    </script>




    <script type="text/javascript">
        $(document).ready(function() {

            const path = window.location.pathname;
            if (path.includes('/search')) {
                filter_data();
            } else {
                filter_data();
            }

            function setActiveButtonByWidth() {
                var width = $(window).width();
                var cols = 4;

                if (width < 576) {
                    cols = 2;
                } else if (width >= 576 && width < 768) {
                    cols = 3;
                } else if (width >= 768 && width < 1200) {
                    cols = 4;
                } else {
                    cols = 4;
                }

                $('.btn-col-filter').removeClass('active-cols');
                $('.btn-col-filter[data-cols="' + cols + '"]').addClass('active-cols');
                $('.row.gutters-16').removeClass('row-cols-2 row-cols-3 row-cols-4 row-cols-6')
                    .addClass('row-cols-' + cols);
            }


            setActiveButtonByWidth();

            $(window).resize(function() {
                setActiveButtonByWidth();
            });

            $('.btn-col-filter').on('click', function() {

                $('.btn-col-filter').removeClass('active-cols');
                $(this).addClass('active-cols');

                var colValue = $(this).data('cols');

                var $row = $('#products-row');

                $row.removeClass(function(index, className) {
                    return (className.match(/(^|\s)row-cols-\S+/g) || []).join(' ');
                });

                $row.addClass('row-cols-xxl-' + colValue);
                $row.addClass('row-cols-xl-' + colValue);
                $row.addClass('row-cols-lg-' + colValue);
                $row.addClass('row-cols-md-' + colValue);
                $row.addClass('row-cols-2');

            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {

            document.querySelectorAll('.see_more_toggle_btn').forEach((btn) => {
                const lessBtn = btn.closest('div').nextElementSibling.querySelector('.less_toggle_btn');
                const element_list = btn.parentElement.previousElementSibling;
                const children = Array.from(element_list.children);


                let visibleCount = 5;

                // first five element show
                children.forEach((child, index) => {
                    // console.log(child)
                    if (index < visibleCount) {
                        child.style.setProperty('display', 'block', 'important');
                    } else {
                        child.style.setProperty('display', 'none', 'important');
                    }
                });
                if (children.length <= 5) {
                    btn.style.display = 'none';
                }

                // click to add more element
                btn.addEventListener('click', () => {

                    visibleCount += 5;

                    children.forEach((child, index) => {
                        if (index < visibleCount) {
                            child.style.setProperty('display', 'block', 'important');
                        }
                    });

                    if (visibleCount >= children.length) {
                        btn.style.display = 'none';
                        lessBtn.style.display = 'inline-block';
                    }
                });


                lessBtn.addEventListener('click', () => {
                    visibleCount = 5;

                    children.forEach((child, index) => {
                        child.style.setProperty('display', index < visibleCount ? 'block' :
                            'none', 'important');
                    });

                    // Toggle buttons
                    lessBtn.style.display = 'none';
                    btn.style.display = 'inline-block';
                });

                lessBtn.style.display = 'none';


            });


        });
    </script>
    <!-- Treeview js -->
    <script src="<?php echo e(static_asset('assets/js/hummingbird-treeview2.js')); ?>"></script>

    <script>
        $(document).ready(function() {

            // $("#treeview2").hummingbird();
            var $tree = $('#treeview2');

            var oldShow = $.fn.show;
            var oldHide = $.fn.hide;

            // Override show for smooth animation
            $.fn.show = function(speed, oldCallback) {
                if ($(this).closest($tree).length) {
                    return this.stop(true, true).slideDown(400, oldCallback);
                } else {
                    return oldShow.apply(this, arguments);
                }
            };

            // Override hide for smooth animation
            $.fn.hide = function(speed, oldCallback) {
                if ($(this).closest($tree).length) {
                    return this.stop(true, true).slideUp(400, oldCallback);
                } else {
                    return oldHide.apply(this, arguments);
                }
            };

            // Initialize Hummingbird treeview2
            $tree.hummingbird();

            var selected_ids = '<?php echo e(implode(',', $old_categories)); ?>';
            if (selected_ids != '') {
                const myArray = selected_ids.split(",");
                for (let i = 0; i < myArray.length; i++) {
                    const element = myArray[i];

                    $('#category_checkidgenerel_' + element).prop('checked', true);
                    $('#category_checkid_textgenerel_' + element).addClass('fw-bold');
                    $('#category_checkidgenerel_' + element).parents("ul").css("display", "block");
                }
            }
        });


        function showLabels() {
            document.querySelectorAll('.slider-value-text').forEach(label => {
                label.style.display = 'block';
            });
        }

        function hideLabels() {
            document.querySelectorAll('.slider-value-text').forEach(label => {
                label.style.display = 'none';
            });
        }


        document.querySelectorAll('.noUi-connect, .noUi-touch-area').forEach((element) => {
            // Desktop 
            element.addEventListener('mouseenter', showLabels);
            element.addEventListener('mouseleave',  function(){
                setTimeout(()=>{
                    hideLabels();
                }, 2000);
            });

            // Mobile 
            element.addEventListener('touchstart', showLabels);
            element.addEventListener('touchend', function(){
                setTimeout(()=>{
                    hideLabels();
                }, 2000);
            });
        });
        document.getElementById('input-slider-range').addEventListener('click', function(){
            showLabels();

            setTimeout(function(){
                hideLabels();
            }, 2000);
        });
    </script>



    <script>
        window.onload = function() {
            setTimeout(function() {

                const mainUl = $('#category_filter div ul');

                if (mainUl.length === 0) {
                    return alert("Main UL not found!");
                }


                function processUl($ul) {
                    $ul.addClass('ul_is_empty');

                    $ul.children('li').each(function() {
                        const $li = $(this);


                        const $nestedUl = $li.children('ul');
                        if ($nestedUl.length > 0) {

                            processUl($nestedUl);



                            if ($nestedUl.children('li').length === 0) {
                                $nestedUl.prev('i.las.pt-3px.la-angle-right').remove();
                                $nestedUl.remove();
                            }
                        } else {
                            const countAttr = $li.attr('count');
                            if (countAttr === "0") {
                                $li.remove();
                            }
                        }
                    });
                }

                processUl(mainUl);

                $('.ul_is_empty').each(function() {
                    const $ul = $(this);

                    if ($ul.children('li').length === 0) {
                        $ul.prev('i.las.pt-3px.la-angle-right').remove();
                        $ul.remove();
                    }
                });

            }, 0000);

            setTimeout(function() {

                const mainUl = $('#category_filter_preorder div ul');

                if (mainUl.length === 0) {
                    return alert("Main UL not found!");
                }


                function processUl($ul) {
                    $ul.addClass('ul_is_empty');


                    $ul.children('li').each(function() {
                        const $li = $(this);


                        const $nestedUl = $li.children('ul');
                        if ($nestedUl.length > 0) {

                            processUl($nestedUl);



                            if ($nestedUl.children('li').length === 0) {
                                $nestedUl.prev('i.las.pt-3px.la-angle-down').remove();
                                $nestedUl.remove();
                            }
                        } else {
                            const countAttr = $li.attr('count');
                            if (countAttr === "0") {
                                $li.remove();
                            }
                        }
                    });
                }

                processUl(mainUl);

                $('.ul_is_empty').each(function() {
                    const $ul = $(this);

                    if ($ul.children('li').length === 0) {
                        $ul.prev('i.las.pt-3px.la-angle-right').remove();
                        $ul.remove();
                    }
                });

            }, 0000);

        };
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/goldqurosh/public_html/resources/views/frontend/product_listing.blade.php ENDPATH**/ ?>