<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="aiz-titlebar text-left mt-2 pb-2 px-3 px-md-2rem border-bottom border-gray">
        <div class="row align-items-center">
            <div class="col">
                <h1 class="h3"><?php echo e(translate('Add New Products')); ?></h1>
            </div>
            <div class="col text-right">
                <a class="btn btn-xs btn-soft-primary" href="javascript:void(0);" onclick="clearTempdata()">
                    <?php echo e(translate('Clear Tempdata')); ?>

                </a>
            </div>
        </div>
    </div>

    <div class="p-3 p-sm-2rem bg-white mt-3">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('products.store')); ?>" method="POST" enctype="multipart/form-data" id="choice_form">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="category_id" id="main_category_id" value="<?php echo e(old('category_id')); ?>">

            <!-- Product Categories -->
            <h5 class="mb-3 pb-3 fs-17 fw-700" style="border-bottom: 1px dashed #e4e5eb;">
                <?php echo e(translate('Product Categories')); ?>

            </h5>
            
            <div class="row g-3">
                <!-- Main Category Dropdown -->
                <div class="col-md-6">
                    <label for="main_category_select" class="form-label fw-medium"><?php echo e(translate('Main Category')); ?></label>
                    <select name="category_id" id="main_category_select" class="form-control aiz-selectpicker" required>
                        <option value=""><?php echo e(translate('Select Main Category')); ?></option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $unitConvertPrice = $category->unit ? $category->unit->convert_price : 1;
                                $unitName = $category->unit ? $category->unit->name : 'Kg';
                            ?>
                            <option value="<?php echo e($category->id); ?>" 
                                    data-unit-convert-price="<?php echo e($unitConvertPrice); ?>"
                                    data-unit-name="<?php echo e($unitName); ?>"
                                    data-measurement-starts-from="<?php echo e($category->measurement_starts_from); ?>"
                                    data-measurement-ends-from="<?php echo e($category->measurement_ends_from); ?>"
                                    <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($category->getTranslation('name')); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            
                <!-- Subcategory Dropdown -->
                <div class="col-md-6">
                    <label for="subcategory_select" class="form-label fw-medium"><?php echo e(translate('Subcategory')); ?></label>
                    <select name="subcategory_id" id="subcategory_select" class="form-control aiz-selectpicker">
                        <option value=""><?php echo e(translate('Select Subcategory')); ?></option>
                    </select>
                </div>
            </div>
            
            <!-- Multiple Products Table -->
            <h5 class="mb-4 mt-4 pb-2 fs-5 fw-bold border-bottom border-dashed border-gray-300">
            <?php echo e(translate('Products List')); ?>

        </h5>
        
        <!-- Main Container -->
        <div class="row mb-4">
            
            <!-- Left: Add Rows -->
            <div class="col-md-6 mb-3 mb-md-0">
                <div class="card border rounded-3">
                    <div class="card-body p-3">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <label class="form-label mb-2 text-dark fw-medium">
                                    <?php echo e(translate('Add Product Rows')); ?>

                                </label>
                                <div class="d-flex gap-2">
                                    <div class="flex-grow-1 position-relative">
                                        <input 
                                            type="number" 
                                            id="add_rows_input"
                                            class="form-control form-control-lg"
                                            value="1"
                                            min="1"
                                            max="50"
                                        >
                                    </div>
                                    <button 
                                        type="button" 
                                        onclick="addMultipleRows()"
                                        class="btn btn-primary btn-lg px-4"
                                    >
                                        <?php echo e(translate('Add')); ?>

                                    </button>
                                </div>
                                <p class="form-text text-muted mb-0 mt-2">
                                    <?php echo e(translate('Enter number and click Add')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right: Global Price -->
            <div class="col-md-6">
                <div class="card border-0 text-white" style="background: linear-gradient(135deg, #0dcaf0 0%, #0a58ca 100%);">
                    <div class="card-body p-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h2 class="mb-1 text-white-75 fw-medium">
                                    <?php echo e(translate('Global Gold Price')); ?>

                                </h2>
                                <h2 class="mb-0 fw-bold display-6" id="global_gold_price">
                                    <?php echo e(gold_price_usd()); ?>

                                </h2>
                                <p class="mb-0 text-white-75 small mt-1">
                                    <?php echo e(translate('Live Price')); ?>

                                </p>
                            </div>
                            <div class="text-white-50">
                                <i class="bi bi-gem fs-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive rounded-3 shadow-sm">
    <table class="table table-bordered table-hover mb-0" id="products_table">
        <thead>
            <tr class="text-center text-white" 
                style="background: linear-gradient(135deg, #0dcaf0 0%, #0a58ca 100%); border-bottom: 3px solid #0a58ca;">
                <th width="12%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Product Name')); ?> *</span>
                </th>
                <th width="12%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Product Name in Arabic')); ?> *</span>
                </th>
                <th hidden width="6%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Min Qty')); ?></span>
                </th>
                <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Weight')); ?></span>
                    <br>
                    <small class="opacity-75 fw-normal" id="weight_unit_label"><?php echo e(translate('In Kg')); ?></small>
                </th>

                <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Measurement')); ?></span>
                </th>

                <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('SKU')); ?></span>
                </th>
                <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('manufacturing')); ?> *</span>
                </th>
                <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Profit')); ?> *</span>
                </th>
                <th width="10%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Total')); ?> *</span>
                </th>
                <th width="7%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Discount')); ?></span>
                </th>
                <th width="10%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Discount Type')); ?></span>
                </th>
                <th hidden width="7%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Quantity')); ?></span>
                </th>
                <th width="10%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Thumbnail')); ?> *</span>
                </th>
                <th width="10%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Gallery')); ?></span>
                </th>

                <?php if(\App\Models\Tax::where('tax_status', 1)->count() > 0): ?>
                    <?php $__currentLoopData = \App\Models\Tax::where('tax_status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th width="8%" class="py-3 align-middle border-end border-white border-opacity-25">
                            <span class="fw-semibold"><?php echo e($tax->name); ?></span>
                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <th width="10%" class="py-3 align-middle border-end border-white border-opacity-25">
                    <span class="fw-semibold"><?php echo e(translate('Flash Deal')); ?></span>
                </th>
                <th width="6%" class="py-3 align-middle">
                    <span class="fw-semibold"><?php echo e(translate('Actions')); ?></span>
                </th>
            </tr>
        </thead>

        <tbody>
            <?php
                $oldProducts = old('products', []);
                $productCount = count($oldProducts) > 0 ? count($oldProducts) : 1;
                $globalGoldPrice = floatval(str_replace(['$', ','], '', gold_price_usd()));
            ?>

            <?php for($i = 0; $i < $productCount; $i++): ?>
            <tr data-index="<?php echo e($i); ?>">
                <td>
                    <input type="text" name="products[<?php echo e($i); ?>][name]" 
                           value="<?php echo e($oldProducts[$i]['name'] ?? ''); ?>" 
                           class="form-control product-name" 
                           placeholder="<?php echo e(translate('Product Name')); ?>" 
                           required>
                    <?php if($errors->has("products.{$i}.name")): ?>
                        <div class="text-danger fs-12"><?php echo e($errors->first("products.{$i}.name")); ?></div>
                    <?php endif; ?>
                </td>
                <td>
                    <input type="text" name="products[<?php echo e($i); ?>][name_ar]" 
                           value="<?php echo e($oldProducts[$i]['name_ar'] ?? ''); ?>" 
                           class="form-control product-name" 
                           placeholder="<?php echo e(translate('Product Name in Arabic')); ?>" 
                           required>
                    <?php if($errors->has("products.{$i}.name_ar")): ?>
                        <div class="text-danger fs-12"><?php echo e($errors->first("products.{$i}.name_ar")); ?></div>
                    <?php endif; ?>
                </td>

                <td hidden>
                    <input type="number" name="products[<?php echo e($i); ?>][min_qty]" 
                           class="form-control min-qty" 
                           value="<?php echo e($oldProducts[$i]['min_qty'] ?? 1); ?>"
                           readonly
                           max="1"
                           min="1" required>
                </td>
                <td>
                    <input type="number" name="products[<?php echo e($i); ?>][weight]" 
                           class="form-control weight" 
                           value="<?php echo e($oldProducts[$i]['weight'] ?? 0.00); ?>"
                           step="0.001"
                           min="0"
                           required
                           oninput="calculateTotal(this)">
                </td>
                <!-- بعد خلية الوزن -->
                <td>
                    <input type="number" 
                           name="products[<?php echo e($i); ?>][measurement]" 
                           class="form-control measurement" 
                           value="<?php echo e($oldProducts[$i]['measurement'] ?? ''); ?>"
                           step="0.1"
                           min="0"
                           required
                           data-index="<?php echo e($i); ?>"
                           onchange="validateMeasurement(this)">
                    <?php if($errors->has("products.{$i}.measurement")): ?>
                        <div class="text-danger fs-12"><?php echo e($errors->first("products.{$i}.measurement")); ?></div>
                    <?php endif; ?>
                    <div class="measurement-error text-danger fs-12" id="measurement-error-<?php echo e($i); ?>" style="display: none;"></div>
                </td>


                <td>
                    <input type="text" name="products[<?php echo e($i); ?>][sku]" 
                           class="form-control sku-input" 
                           value="<?php echo e($oldProducts[$i]['sku'] ?? ''); ?>" 
                           placeholder="<?php echo e(translate('SKU')); ?>">
                </td>

                <td>
                    <input type="number" name="products[<?php echo e($i); ?>][unit_price]" 
                           class="form-control unit-price" 
                           value="<?php echo e($oldProducts[$i]['unit_price'] ?? 0); ?>" 
                           min="0" step="0.01" required
                           oninput="calculateTotal(this)">
                    <?php if($errors->has("products.{$i}.unit_price")): ?>
                        <div class="text-danger fs-12"><?php echo e($errors->first("products.{$i}.unit_price")); ?></div>
                    <?php endif; ?>
                </td>
                <td>
                    <input type="number" name="products[<?php echo e($i); ?>][profit]" 
                           class="form-control profit" 
                           value="<?php echo e($oldProducts[$i]['profit'] ?? 0.00); ?>"
                           step="0.01"
                           min="0"
                           required
                           oninput="calculateTotal(this)">
                </td>

                <!-- New Total Column -->
                <td>
                    <input type="number" 
                           name="products[<?php echo e($i); ?>][total]" 
                           class="form-control total-price" 
                           value="<?php echo e($oldProducts[$i]['total'] ?? 0); ?>"
                           readonly
                           step="0.01"
                           min="0"
                           required>
                </td>

                <td>
                    <input type="number" name="products[<?php echo e($i); ?>][discount]" 
                           class="form-control discount" 
                           value="<?php echo e($oldProducts[$i]['discount'] ?? 0); ?>" 
                           min="0" step="0.01">
                </td>

                <td>
                    <select name="products[<?php echo e($i); ?>][discount_type]" class="form-control aiz-selectpicker discount-type">
                        <option value="amount" <?php echo e(($oldProducts[$i]['discount_type'] ?? 'amount') == 'amount' ? 'selected' : ''); ?>>
                            <?php echo e(translate('Flat')); ?>

                        </option>
                        <option value="percent" <?php echo e(($oldProducts[$i]['discount_type'] ?? '') == 'percent' ? 'selected' : ''); ?>>
                            <?php echo e(translate('Percent')); ?>

                        </option>
                    </select>
                </td>

                <td  hidden>
                    <input type="number"
                           name="products[<?php echo e($i); ?>][current_stock]"
                           class="form-control current-stock"
                           value="<?php echo e($oldProducts[$i]['current_stock'] ?? 1); ?>"
                           min="1"
                           max="1"
                           readonly
                          
                           required>
                </td>


                <!-- Thumbnail -->
                <td>
                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary"><?php echo e(translate('Browse')); ?></div>
                        </div>
                        <div class="form-control file-amount"><?php echo e(translate('Choose File')); ?></div>
                        <input type="hidden" name="products[<?php echo e($i); ?>][thumbnail_img]" 
                               class="selected-files thumbnail-input" 
                               value="<?php echo e($oldProducts[$i]['thumbnail_img'] ?? ''); ?>">
                    </div>
                    <div class="file-preview box sm"></div>
                    <?php if($errors->has("products.{$i}.thumbnail_img")): ?>
                        <div class="text-danger fs-12"><?php echo e($errors->first("products.{$i}.thumbnail_img")); ?></div>
                    <?php endif; ?>
                </td>

                <!-- Gallery -->
                <td>
                    <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="true">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary"><?php echo e(translate('Browse')); ?></div>
                        </div>
                        <div class="form-control file-amount"><?php echo e(translate('Choose Files')); ?></div>
                        <input type="hidden" name="products[<?php echo e($i); ?>][photos]" 
                               class="selected-files" 
                               value="<?php echo e($oldProducts[$i]['photos'] ?? ''); ?>">
                    </div>
                    <div class="file-preview box sm"></div>
                </td>

                <!-- TAX -->
                <?php if(\App\Models\Tax::where('tax_status', 1)->count() > 0): ?>
                    <?php
                        $taxes = \App\Models\Tax::where('tax_status', 1)->get();
                    ?>
                    <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxIndex => $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td>
                            <input type="hidden" name="products[<?php echo e($i); ?>][tax_id][<?php echo e($taxIndex); ?>]" value="<?php echo e($tax->id); ?>">
                            <input type="number" name="products[<?php echo e($i); ?>][tax][<?php echo e($taxIndex); ?>]" 
                                   class="form-control mb-1 tax-amount" 
                                   value="<?php echo e($oldProducts[$i]['tax'][$taxIndex] ?? 0); ?>" 
                                   step="0.01" min="0">
                    
                            <select name="products[<?php echo e($i); ?>][tax_type][<?php echo e($taxIndex); ?>]" class="form-control aiz-selectpicker tax-type">
                                <option value="amount" <?php echo e((($oldProducts[$i]['tax_type'][$taxIndex] ?? null) == 'amount') ? 'selected' : ''); ?>>
                                    <?php echo e(translate('Flat')); ?>

                                </option>
                                <option value="percent" <?php echo e((($oldProducts[$i]['tax_type'][$taxIndex] ?? null) == 'percent') ? 'selected' : ''); ?>>
                                    <?php echo e(translate('Percent')); ?>

                                </option>
                            </select>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <!-- Flash Deal -->
                <td>
                    <select name="products[<?php echo e($i); ?>][flash_deal_id]" class="form-control aiz-selectpicker flash-deal">
                        <option value=""><?php echo e(translate('Choose Flash Title')); ?></option>
                        <?php $__currentLoopData = \App\Models\FlashDeal::where("status", 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flash_deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($flash_deal->id); ?>" 
                                <?php echo e(($oldProducts[$i]['flash_deal_id'] ?? '') == $flash_deal->id ? 'selected' : ''); ?>>
                                <?php echo e($flash_deal->title); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>

                <td class="text-center">
                    <?php if($i === 0): ?>
                        <button type="button" class="btn btn-sm btn-primary" onclick="addRow()">
                            <i class="las la-plus"></i> <?php echo e(translate('Add')); ?>

                        </button>
                    <?php else: ?>
                        <button type="button" class="btn btn-sm btn-danger" onclick="removeRow(this)">
                            <i class="las la-trash"></i> <?php echo e(translate('Remove')); ?>

                        </button>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endfor; ?>
        </tbody>
    </table>
</div>

            <!-- Save Buttons -->
            <div class="mt-4 text-end border-top pt-3">
                <button type="submit" name="button" value="unpublish" class="btn btn-light w-230px">
                    <i class="las la-save"></i> <?php echo e(translate('Save & Unpublish')); ?>

                </button>
                <button type="submit" name="button" value="publish" class="btn btn-success w-230px">
                    <i class="las la-check-circle"></i> <?php echo e(translate('Save & Publish')); ?>

                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(static_asset('assets/js/hummingbird-treeview.js')); ?>"></script>

<script>
let categories = <?php echo json_encode($categories, 15, 512) ?>;
let selectedCategoryName = '';
let unitConvertPrice = 1;
let globalGoldPrice = parseFloat("<?php echo e(str_replace(['$', ','], '', gold_price_usd())); ?>");
// إضافة متغير لتخزين نطاق القياس المسموح به للفئة المحددة
let currentMeasurementRange = { min: 0, max: Infinity };

// Update subcategories
function updateSubcategories(mainCategoryId) {
    const subSelect = document.getElementById('subcategory_select');
    subSelect.innerHTML = '<option value=""><?php echo e(translate("Select Subcategory")); ?></option>';

    const mainCat = categories.find(c => c.id == mainCategoryId);
    if (mainCat && mainCat.children_categories.length > 0) {
        mainCat.children_categories.forEach(sub => {
            const option = document.createElement('option');
            option.value = sub.id;
            option.textContent = sub.name;
            
            const subConvertPrice = sub.unit ? sub.unit.convert_price : mainCat.unit ? mainCat.unit.convert_price : 1;
            option.setAttribute('data-unit-convert-price', subConvertPrice);
            
            const subUnitName = sub.unit ? sub.unit.name : mainCat.unit ? mainCat.unit.name : 'Kg';
            option.setAttribute('data-unit-name', subUnitName);
            
            subSelect.appendChild(option);
        });
    }

    if (typeof AIZ !== 'undefined') AIZ.plugins.bootstrapSelect("refresh");
}

// When main category changes
document.getElementById('main_category_select').addEventListener('change', function() {
    const mainId = this.value;
    const selectedOption = this.options[this.selectedIndex];
    
    // فقط: الحصول على اسم الفئة
    selectedCategoryName = selectedOption.text;
    
    // فقط: تحديث أسماء المنتجات
    updateAllProductNamesWithCategory();
    
    // تحديث الفئات الفرعية (الرموز الأخرى تبقى كما هي)
    updateSubcategories(mainId);

    // باقي الكود يبقى كما هو
    unitConvertPrice = parseFloat(selectedOption.getAttribute('data-unit-convert-price')) || 1;
    
    // ✅ التصحيح المهم: الحصول على قيم القياس من البيانات المخزنة في الـ option
    const measurementStartsFrom = selectedOption.getAttribute('data-measurement-starts-from');
    const measurementEndsFrom = selectedOption.getAttribute('data-measurement-ends-from');
    
    currentMeasurementRange = {
        min: measurementStartsFrom ? parseFloat(measurementStartsFrom) : 0,
        max: measurementEndsFrom ? parseFloat(measurementEndsFrom) : Infinity
    };
    
    console.log('Measurement Range:', currentMeasurementRange); // للتأكد من القيم
    
    // أعد التحقق من جميع حقول القياس بعد تغيير الفئة
    document.querySelectorAll('.measurement').forEach(function(input) {
        validateMeasurement(input);
    });
    
    updateWeightUnitLabel();
    recalculateAllTotals();
});

// When subcategory changes
document.getElementById('subcategory_select').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    
    if (this.value) {
        // فقط: الحصول على اسم الفئة الفرعية
        const subCategoryName = selectedOption.text;
        
        // فقط: تحديث أسماء المنتجات مع اسم الفئة الفرعية
        updateAllProductNamesWithCategory(subCategoryName);
        
        // باقي الكود يبقى كما هو
        const subConvertPrice = parseFloat(selectedOption.getAttribute('data-unit-convert-price'));
        if (!isNaN(subConvertPrice)) {
            unitConvertPrice = subConvertPrice;
        }
        
        const subUnitName = selectedOption.getAttribute('data-unit-name') || 'Kg';
        document.getElementById('weight_unit_label').textContent = `<?php echo e(translate('In')); ?> ${subUnitName}`;
        
        recalculateAllTotals();
    } else {
        // إذا تم إلغاء اختيار الفئة الفرعية، استخدم اسم الفئة الرئيسية
        if (selectedCategoryName) {
            updateAllProductNamesWithCategory();
        }
        updateWeightUnitLabel();
    }
});

// فقط: تحديث أسماء المنتجات
function updateAllProductNamesWithCategory(categoryName = null) {
    const nameToUse = categoryName || selectedCategoryName;
    
    if (!nameToUse) return;

    // تحديث حقل اسم المنتج فقط
    document.querySelectorAll('.product-name').forEach(input => {
        input.value = nameToUse;
        generateAutoSKU(input);
    });
}

// SKU generator
function generateAutoSKU(input) {
    const row = input.closest('tr');
    const skuInput = row.querySelector('.sku-input');

    if (!skuInput.value.trim()) {
        const productName = input.value.trim();
        if (productName) {
            let baseSku = productName
                .toUpperCase()
                .replace(/[^A-Z0-9]/g, '')
                .substring(0, 10);

            const randomNum = Math.floor(1000 + Math.random() * 100000);
            skuInput.value = baseSku + randomNum;
        }
    }
}

// Calculate total price
function calculateTotal(inputElement) {
    const row = inputElement.closest('tr');
    
    const weight = parseFloat(row.querySelector('.weight').value) || 0;
    const manufacturing = parseFloat(row.querySelector('.unit-price').value) || 0;
    const profit = parseFloat(row.querySelector('.profit').value) || 0;
    
    let calculatedTotal = 0;
    
    if (globalGoldPrice && unitConvertPrice > 0 && weight > 0) {
        const goldPricePerUnit = globalGoldPrice / 31.1;
        const weightPrice = goldPricePerUnit * unitConvertPrice * weight;
        calculatedTotal = weightPrice + manufacturing + profit;
    } else {
        calculatedTotal = manufacturing + profit;
    }
    
    const totalInput = row.querySelector('.total-price');
    totalInput.value = calculatedTotal.toFixed(2);
}

// Recalculate all totals
function recalculateAllTotals() {
    // التحقق من صحة القياسات عند إعادة الحساب
    document.querySelectorAll('.measurement').forEach(input => {
        validateMeasurement(input);
    });
    
    document.querySelectorAll('#products_table tbody tr').forEach(row => {
        const weight = parseFloat(row.querySelector('.weight').value) || 0;
        const manufacturing = parseFloat(row.querySelector('.unit-price').value) || 0;
        const profit = parseFloat(row.querySelector('.profit').value) || 0;
        
        let calculatedTotal = 0;
        
        if (globalGoldPrice && unitConvertPrice > 0 && weight > 0) {
            const goldPricePerUnit = globalGoldPrice / unitConvertPrice;
            const weightPrice = goldPricePerUnit * weight;
            calculatedTotal = weightPrice + manufacturing + profit;
        } else {
            calculatedTotal = manufacturing + profit;
        }
        
        const totalInput = row.querySelector('.total-price');
        totalInput.value = calculatedTotal.toFixed(2);
    });
}

// دالة التحقق من القياس - جديدة فقط
function validateMeasurement(input) {
    if (!input) return true;
    
    const row = input.closest('tr');
    if (!row) return true;
    
    const measurementValue = parseFloat(input.value) || 0;
    const rowIndex = row.getAttribute('data-index');
    
    // البحث عن عنصر الخطأ أو إنشاؤه
    let errorDiv = document.getElementById(`measurement-error-${rowIndex}`);
    if (!errorDiv) {
        errorDiv = document.createElement('div');
        errorDiv.id = `measurement-error-${rowIndex}`;
        errorDiv.className = 'measurement-error text-danger fs-12';
        errorDiv.style.display = 'none';
        input.parentNode.appendChild(errorDiv);
    }
    
    const categorySelect = document.getElementById('main_category_select');
    if (!categorySelect.value) {
        errorDiv.style.display = 'block';
        errorDiv.textContent = '<?php echo e(translate("Please select a category first")); ?>';
        input.classList.add('is-invalid');
        return false;
    }
    
    // ✅ التحقق من صحة القياس
    if (measurementValue < currentMeasurementRange.min || measurementValue > currentMeasurementRange.max) {
        errorDiv.style.display = 'block';
        errorDiv.textContent = `<?php echo e(translate("Measurement must be between")); ?> ${currentMeasurementRange.min} - ${currentMeasurementRange.max} <?php echo e(translate("grams")); ?>`;
        input.classList.add('is-invalid');
        return false;
    } else {
        errorDiv.style.display = 'none';
        input.classList.remove('is-invalid');
        return true;
    }
}

// On page load
window.addEventListener('DOMContentLoaded', function() {
    const mainSelect = document.getElementById('main_category_select');
    const subSelect = document.getElementById('subcategory_select');
    const oldMain = mainSelect.value;
    const oldSub = "<?php echo e(old('subcategory_id')); ?>";
    
    if (oldMain) {
        const selectedOption = mainSelect.options[mainSelect.selectedIndex];
        // فقط: الحصول على اسم الفئة
        selectedCategoryName = selectedOption.text;
        
        // فقط: تحديث أسماء المنتجات
        updateAllProductNamesWithCategory();
        
        // باقي الكود يبقى كما هو
        unitConvertPrice = parseFloat(selectedOption.getAttribute('data-unit-convert-price')) || 1;
        
        // ✅ التصحيح: الحصول على قيم القياس عند تحميل الصفحة
        const measurementStartsFrom = selectedOption.getAttribute('data-measurement-starts-from');
        const measurementEndsFrom = selectedOption.getAttribute('data-measurement-ends-from');
        
        currentMeasurementRange = {
            min: measurementStartsFrom ? parseFloat(measurementStartsFrom) : 0,
            max: measurementEndsFrom ? parseFloat(measurementEndsFrom) : Infinity
        };
        
        console.log('Initial Measurement Range:', currentMeasurementRange); // للتأكد من القيم
        
        updateSubcategories(oldMain);
        
        if (oldSub) {
            setTimeout(() => {
                subSelect.value = oldSub;
                const subOption = subSelect.options[subSelect.selectedIndex];
                if (subOption) {
                    // فقط: تحديث أسماء المنتجات مع اسم الفئة الفرعية
                    const subCategoryName = subOption.text;
                    updateAllProductNamesWithCategory(subCategoryName);
                    
                    const subConvertPrice = parseFloat(subOption.getAttribute('data-unit-convert-price'));
                    if (!isNaN(subConvertPrice)) {
                        unitConvertPrice = subConvertPrice;
                    }
                }
                recalculateAllTotals();
            }, 100);
        } else {
            recalculateAllTotals();
        }
    }
    
    // Add event listeners for measurement fields
    document.querySelectorAll('.measurement').forEach(input => {
        input.addEventListener('change', function() {
            validateMeasurement(this);
        });
        input.addEventListener('keyup', function() {
            validateMeasurement(this);
        });
        input.addEventListener('blur', function() {
            validateMeasurement(this);
        });
    });
    
    // Add event listeners
    document.querySelectorAll('.weight, .unit-price, .profit').forEach(input => {
        input.addEventListener('input', function() {
            calculateTotal(this);
        });
    });
});

// Update weight unit label
function updateWeightUnitLabel() {
    const mainSelect = document.getElementById('main_category_select');
    const selectedOption = mainSelect.options[mainSelect.selectedIndex];
    
    const unitName = selectedOption.getAttribute('data-unit-name') || 'Kg';
    document.getElementById('weight_unit_label').textContent = `<?php echo e(translate('In')); ?> ${unitName}`;
}

let rowIndex = <?php echo e($productCount); ?>;

function addMultipleRows() {
    const count = parseInt(document.getElementById('add_rows_input').value) || 1;
    for (let i = 0; i < count; i++) {
        addRow();
    }
}

function addRow() {
    const tbody = document.querySelector('#products_table tbody');
    const newRow = tbody.children[0].cloneNode(true);
    const newIndex = rowIndex;

    newRow.setAttribute('data-index', newIndex);
    
    // مسح القيم
    newRow.querySelectorAll("input[type='text'], input[type='number']").forEach(function (el) {
        if (el.classList.contains('product-name')) {
            el.value = selectedCategoryName || "";
        } else if (el.classList.contains('sku-input')) {
            el.value = '';
        } else if (el.classList.contains('weight')) {
            el.value = '0.00';
        } else if (el.classList.contains('unit-price')) {
            el.value = '0';
        } else if (el.classList.contains('profit')) {
            el.value = '0.00';
        } else if (el.classList.contains('total-price')) {
            el.value = '0.00';
        } else if (el.classList.contains('discount')) {
            el.value = '0';
        } else if (el.classList.contains('measurement')) {
            el.value = '';
        } else {
            el.value = '';
        }
    });
    
    // تحديث الأسماء
    newRow.querySelectorAll("input, select").forEach(function (el) {
        let name = el.getAttribute("name");
        if (name) {
            el.setAttribute("name", name.replace(/\[\d+\]/, `[${newIndex}]`));
        }
    });
    
    // إضافة حدث التحقق للقياس
    const measurementInput = newRow.querySelector('.measurement');
    if (measurementInput) {
        measurementInput.addEventListener('change', function() {
            validateMeasurement(this);
        });
        measurementInput.addEventListener('keyup', function() {
            validateMeasurement(this);
        });
        measurementInput.addEventListener('blur', function() {
            validateMeasurement(this);
        });
    }
    
    tbody.appendChild(newRow);
    
    // إعادة تهيئة الـ select pickers
    if (typeof AIZ !== 'undefined' && AIZ.plugins && AIZ.plugins.bootstrapSelect) {
        AIZ.plugins.bootstrapSelect.refresh();
    }
    
    rowIndex++;
}

function removeRow(button) {
    const row = button.closest('tr');
    if (document.querySelectorAll('#products_table tbody tr').length > 1) {
        row.remove();
        reindexRows();
    }
}

function reindexRows() {
    const rows = document.querySelectorAll("#products_table tbody tr");
    rowIndex = 0;
    
    rows.forEach((row, index) => {
        row.setAttribute('data-index', index);
        
        row.querySelectorAll("input, select").forEach(function (el) {
            let name = el.getAttribute("name");
            if (name) {
                el.setAttribute("name", name.replace(/\[\d+\]/, `[${index}]`));
            }
            
            // فقط: تحديث اسم المنتج إذا كان فارغاً والفئة محددة
            if (selectedCategoryName && el.classList.contains('product-name') && !el.value.trim()) {
                el.value = selectedCategoryName;
                generateAutoSKU(el);
            }
        });
        
        // إعادة إنشاء عناصر الخطأ للقياس بعد إعادة الترتيب
        const measurementInput = row.querySelector('.measurement');
        if (measurementInput) {
            const errorId = `measurement-error-${index}`;
            let errorDiv = document.getElementById(errorId);
            if (!errorDiv) {
                errorDiv = document.createElement('div');
                errorDiv.id = errorId;
                errorDiv.className = 'measurement-error text-danger fs-12';
                errorDiv.style.display = 'none';
                measurementInput.parentNode.appendChild(errorDiv);
            }
        }
        
        rowIndex = index + 1;
    });
}

// Add Enter key support
document.getElementById('add_rows_input').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        addMultipleRows();
    }
});

$(document).ready(function() {
    // تأكد من تحميل الـ select picker
    if (typeof AIZ !== 'undefined' && AIZ.plugins && AIZ.plugins.bootstrapSelect) {
        AIZ.plugins.bootstrapSelect.init();
    }
});

function getSelectedCategoryName() {
    const selectedCheckbox = $('#treeview input:checkbox:checked').first();
    if (selectedCheckbox.length > 0) {
        const label = selectedCheckbox.closest('li').find('label').first();
        if (label.length > 0) {
            return label.text().trim();
        }
    }
    return '';
}
</script>

<?php echo $__env->make('partials.product.product_temp_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/goldqurosh/public_html/resources/views/backend/product/products/create.blade.php ENDPATH**/ ?>