<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="aiz-titlebar text-left mt-2 pb-2 px-3 px-md-2rem">
        <div class="row align-items-center">
            <div class="col">
                <div class="d-flex align-items-center">
                    <div class="icon-container mr-3">
                        <i class="las la-edit fs-24 text-primary"></i>
                    </div>
                    <div>
                        <h1 class="h3 mb-1 fw-700 text-dark"><?php echo e(translate('Edit Product')); ?></h1>
                        <p class="text-muted mb-0 fs-13">ID: #<?php echo e($product->id); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="flex-grow-1 p-sm-3 p-lg-2rem mb-2rem mb-md-0">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-modern mb-4">
                <div class="d-flex align-items-center">
                    <i class="las la-exclamation-triangle fs-18 mr-3"></i>
                    <div class="flex-grow-1">
                        <h6 class="mb-1 fw-600"><?php echo e(translate('Validation Errors')); ?></h6>
                        <ul class="mb-0 pl-3">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('products.update', $product->id)); ?>" method="POST" enctype="multipart/form-data" id="product-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
            <input type="hidden" name="lang" value="<?php echo e($lang); ?>">
            <input type="hidden" name="tab" id="tab">

            <!-- Language Tabs -->
            <div class="card language-card mb-4">
                <div class="card-body p-0">
                    <div class="px-3 pt-3">
                        <div class="d-flex align-items-center mb-2">
                            <i class="las la-language text-primary mr-2 fs-16"></i>
                            <h6 class="mb-0 fw-600 fs-14"><?php echo e(translate('Edit Language')); ?></h6>
                        </div>
                        <p class="text-muted fs-12 mb-3"><?php echo e(translate('Select language to edit content')); ?></p>
                    </div>
                    <ul class="nav nav-tabs nav-fill language-bar mb-0">
                        <?php $__currentLoopData = get_all_active_language(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a class="nav-link text-reset <?php if($language->code == $lang): ?> active <?php endif; ?> py-3" href="<?php echo e(route('products.admin.edit', ['id'=>$product->id, 'lang'=> $language->code])); ?>">
                                <div class="d-flex align-items-center justify-content-center">
                                    <img src="<?php echo e(static_asset('assets/img/flags/'.$language->code.'.png')); ?>" height="16" class="rounded mr-2">
                                    <span class="fw-500"><?php echo e($language->name); ?></span>
                                </div>
                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>

            <div class="bg-white p-3 p-sm-2rem rounded-lg">

                <!-- Product Information -->
                <div class="section-header mb-4">
                    <div class="d-flex align-items-center">
                        <div class="section-icon mr-3">
                            <i class="las la-info-circle text-primary"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 fs-17 fw-700 text-dark"><?php echo e(translate('Product Information')); ?></h5>
                            <p class="text-muted fs-12 mb-0"><?php echo e(translate('Basic product details')); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-xxl-7 col-xl-6">
                        <div class="form-group-row mb-4">
                            <label class="col-xxl-3 col-from-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Product Name')); ?> <span class="text-danger">*</span>
                            </label>
                            <div class="col-xxl-9">
                                <div class="input-group-modern">
                                    <input type="text" class="form-control" name="name" value="<?php echo e($product->getTranslation('name', $lang)); ?>" placeholder="<?php echo e(translate('Product Name')); ?>">
                                </div>
                            </div>
                        </div>

                        <div hidden class="form-group-row mb-4">
                            <label class="col-xxl-3 col-from-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Minimum Purchase Qty')); ?> <span class="text-danger">*</span>
                            </label>
                            <div class="col-xxl-9">
                                <div class="input-group-modern">
                                    <input type="number" name="min_qty" class="form-control" value="<?php echo e($product->min_qty <= 1 ? 1 : $product->min_qty); ?>" min="1">
                                </div>
                                <small class="text-muted fs-11 mt-2 d-block"><?php echo e(translate("The minimum quantity needs to be purchased by your customer.")); ?></small>
                            </div>
                        </div>

                        <div class="form-group-row mb-4">
                            <label class="col-xxl-3 col-from-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('Tags')); ?></label>
                            <div class="col-xxl-9">
                                <div class="input-group-modern">
                                    <input type="text" class="form-control aiz-tag-input" name="tags[]" value="<?php echo e($product->tags); ?>" placeholder="<?php echo e(translate('Type to add a tag')); ?>" data-role="tagsinput">
                                </div>
                                <small class="text-muted fs-11 mt-2 d-block"><?php echo e(translate('This is used for search. Input words by which customers can find this product.')); ?></small>
                            </div>
                        </div>

                        <div class="form-group-row mb-4">
                            <label class="col-xxl-3 col-from-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Weight')); ?> <small class="text-muted">(<?php echo e(translate('In Kg')); ?>)</small>
                            </label>
                            <div class="col-xxl-9">
                                <div class="input-group-modern">
                                    <input type="number" class="form-control" name="weight" value="<?php echo e($product->weight); ?>" step="0.01" placeholder="0.00">
                                </div>
                            </div>
                        </div>

                        <!-- حقل القياس الجديد -->
                        <div class="form-group-row mb-4">
                            <label class="col-xxl-3 col-from-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Measurement')); ?>

                                <small class="text-muted">(<?php echo e(translate('In Grams')); ?>)</small>
                            </label>
                            <div class="col-xxl-9">
                                <div class="input-group-modern">
                                    <input type="number" class="form-control" 
                                           name="measurement" 
                                           id="measurement-input"
                                           value="<?php echo e($product->measurement); ?>" 
                                           step="0.1" 
                                           min="0" 
                                           placeholder="0.00">
                                </div>
                                <div id="measurement-error" class="text-danger fs-12 mt-1" style="display: none;"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Product Categories -->
                    <div class="col-xxl-5 col-xl-6">
                        <div class="card category-card <?php if($errors->has('category_ids') || $errors->has('category_id')): ?> border-danger <?php endif; ?>">
                            <div class="card-header bg-light py-3">
                                <div class="d-flex align-items-center">
                                    <i class="las la-folder-tree text-success mr-2"></i>
                                    <h5 class="mb-0 h6 fw-600"><?php echo e(translate('Product Category')); ?></h5>
                                </div>
                            </div>
                            <div class="card-body p-3">
                                <p class="text-muted fs-11 mb-3"><?php echo e(translate('Select product categories')); ?></p>
                                <?php
                                    $old_categories = $product->categories()->pluck('category_id')->toArray();
                                ?>
                                <div class="h-300px overflow-auto c-scrollbar-light category-tree-container">
                                    <ul class="hummingbird-treeview-converter list-unstyled mb-0" data-checkbox-name="category_ids[]" data-radio-name="category_id">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li id="<?php echo e($category->id); ?>" class="category-item mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="las la-folder mr-2 text-warning fs-14"></i>
                                                <span class="fw-500"><?php echo e($category->getTranslation('name')); ?></span>
                                            </div>
                                            <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo $__env->make('backend.product.products.child_category', ['child_category' => $childCategory], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Description -->
                <div class="form-group mt-4 mb-4">
                    <div class="d-flex align-items-center mb-3">
                        <i class="las la-align-left text-info mr-2 fs-16"></i>
                        <label class="form-label fs-14 fw-500 mb-0"><?php echo e(translate('Description')); ?></label>
                    </div>
                    <div class="border-light rounded-lg overflow-hidden">
                        <textarea class="aiz-text-editor" name="description"><?php echo e($product->getTranslation('description', $lang)); ?></textarea>
                    </div>
                </div>

                <!-- Price & Stock -->
                <div class="section-header mb-4 mt-5">
                    <div class="d-flex align-items-center">
                        <div class="section-icon mr-3">
                            <i class="las la-money-bill-wave text-success"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 fs-17 fw-700 text-dark"><?php echo e(translate('Price & Stock')); ?></h5>
                            <p class="text-muted fs-12 mb-0"><?php echo e(translate('Pricing and inventory details')); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Unit price')); ?> *
                            </label>
                            <div class="input-group-modern">
                                <input type="text" name="unit_price" class="form-control" value="<?php echo e($product->unit_price); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Profit')); ?> *
                            </label>
                            <div class="input-group-modern">
                                <input type="number" name="profit" class="form-control" value="<?php echo e($product->profit); ?>" required>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Flash Deal & Discount -->
                <div class="section-header mb-4 mt-5">
                    <div class="d-flex align-items-center">
                        <div class="section-icon mr-3">
                            <i class="las la-bolt text-warning"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 fs-17 fw-700 text-dark"><?php echo e(translate('Flash Deal')); ?></h5>
                            <p class="text-muted fs-12 mb-0"><?php echo e(translate('Time-limited promotional offers')); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('Add To Flash')); ?></label>
                            <?php
                                $productFlashDealId = $product->flash_deal_products->last()->flash_deal_id ?? null;
                            ?>
                            <div class="input-group-modern">
                                <select class="form-control aiz-selectpicker" name="flash_deal_id">
                                    <option value=""><?php echo e(translate('Choose Flash Title')); ?></option>
                                    <?php $__currentLoopData = \App\Models\FlashDeal::where("status", 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flash_deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($flash_deal->id); ?>" <?php if($productFlashDealId == $flash_deal->id): ?> selected <?php endif; ?>>
                                            <?php echo e($flash_deal->title); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('Discount')); ?></label>
                            <div class="input-group-modern">
                                <input type="number" name="flash_discount" value="<?php echo e($product->discount); ?>" min="0" step="0.01" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('Discount Type')); ?></label>
                            <div class="input-group-modern">
                                <select class="form-control aiz-selectpicker" name="flash_discount_type">
                                    <option value="amount" <?php if($product->discount_type == 'amount'): echo 'selected'; endif; ?>><?php echo e(translate('Flat')); ?></option>
                                    <option value="percent" <?php if($product->discount_type == 'percent'): echo 'selected'; endif; ?>><?php echo e(translate('Percent')); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TAX -->
                <div class="section-header mb-4 mt-5">
                    <div class="d-flex align-items-center">
                        <div class="section-icon mr-3">
                            <i class="las la-receipt text-danger"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 fs-17 fw-700 text-dark"><?php echo e(translate('Vat & TAX')); ?></h5>
                            <p class="text-muted fs-12 mb-0"><?php echo e(translate('Tax configuration')); ?></p>
                        </div>
                    </div>
                </div>

                <?php $__currentLoopData = \App\Models\Tax::where('tax_status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $tax_amount = 0;
                        $tax_type = '';
                        foreach($tax->product_taxes as $row) {
                            if($product->id == $row->product_id) {
                                $tax_amount = $row->tax;
                                $tax_type = $row->tax_type;
                            }
                        }
                    ?>
                    <div class="form-row mb-3">
                        <div class="col-md-6 mb-2 mb-md-0">
                            <div class="d-flex align-items-center mb-2">
                                <i class="las la-file-invoice-dollar text-muted mr-2 fs-14"></i>
                                <label class="form-label fs-13 fw-500 mb-0"><?php echo e($tax->name); ?></label>
                            </div>
                            <div class="input-group-modern">
                                <input type="number" name="tax[]" value="<?php echo e($tax_amount); ?>" class="form-control" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('Tax Type')); ?></label>
                            <select name="tax_type[]" class="form-control aiz-selectpicker">
                                <option value="amount" <?php if($tax_type=='amount'): ?> selected <?php endif; ?>><?php echo e(translate('Flat')); ?></option>
                                <option value="percent" <?php if($tax_type=='percent'): ?> selected <?php endif; ?>><?php echo e(translate('Percent')); ?></option>
                            </select>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Stock & SKU -->
                <div class="row mt-4">
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block">
                                <?php echo e(translate('Quantity')); ?> *
                            </label>
                            <div class="input-group-modern">
                                <input type="number" name="current_stock" class="form-control" value="<?php echo e(optional($product->stocks->first())->qty ?? 0); ?>" step="1">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-2 d-block"><?php echo e(translate('SKU')); ?></label>
                            <div class="input-group-modern">
                                <input type="text" name="sku" class="form-control" value="<?php echo e(optional($product->stocks->first())->sku); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Gallery & Thumbnail -->
                <div class="section-header mb-4 mt-5">
                    <div class="d-flex align-items-center">
                        <div class="section-icon mr-3">
                            <i class="las la-images text-purple"></i>
                        </div>
                        <div>
                            <h5 class="mb-1 fs-17 fw-700 text-dark"><?php echo e(translate('Files & Media')); ?></h5>
                            <p class="text-muted fs-12 mb-0"><?php echo e(translate('Product images and media')); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-3 d-block"><?php echo e(translate('Gallery Images')); ?></label>
                            <div class="upload-card">
                                <div class="upload-area" data-toggle="aizuploader" data-type="image" data-multiple="true">
                                    <div class="upload-icon">
                                        <i class="las la-cloud-upload-alt fs-36 text-muted"></i>
                                    </div>
                                    <div class="upload-text">
                                        <h6 class="fs-14 fw-500 mb-1"><?php echo e(translate('Click or drag images here')); ?></h6>
                                        <p class="text-muted fs-12 mb-3"><?php echo e(translate('Supports: JPG, PNG, GIF')); ?></p>
                                        <button type="button" class="btn btn-outline-primary btn-sm">
                                            <i class="las la-folder-open mr-1"></i> <?php echo e(translate('Browse Files')); ?>

                                        </button>
                                    </div>
                                    <input type="hidden" name="photos" value="<?php echo e($product->photos); ?>" class="selected-files">
                                </div>
                            </div>
                            <div class="file-preview box sm mt-3"></div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="form-group-row mb-4">
                            <label class="form-label fs-13 fw-500 mb-3 d-block"><?php echo e(translate('Thumbnail Image')); ?></label>
                            <div class="upload-card">
                                <div class="upload-area" data-toggle="aizuploader" data-type="image">
                                    <div class="upload-icon">
                                        <i class="las la-image fs-36 text-muted"></i>
                                    </div>
                                    <div class="upload-text">
                                        <h6 class="fs-14 fw-500 mb-1"><?php echo e(translate('Main product thumbnail')); ?></h6>
                                        <p class="text-muted fs-12 mb-3"><?php echo e(translate('Primary display image')); ?></p>
                                        <button type="button" class="btn btn-outline-secondary btn-sm">
                                            <i class="las la-upload mr-1"></i> <?php echo e(translate('Upload Image')); ?>

                                        </button>
                                    </div>
                                    <input type="hidden" name="thumbnail_img" value="<?php echo e($product->thumbnail_img); ?>" class="selected-files">
                                </div>
                            </div>
                            <div class="file-preview box sm mt-3"></div>
                        </div>
                    </div>
                </div>

                <!-- Update Button -->
                <div class="mt-5 pt-4 border-top-light">
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-success btn-lg px-5 py-3">
                            <i class="las la-save mr-2"></i>
                            <?php echo e(translate('Update Product')); ?>

                        </button>
                    </div>
                </div>

            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <!-- Frequently Bought Product Select Modal -->
    <?php echo $__env->make('modals.product_select_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('modals.note_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<!-- Treeview js -->
<script src="<?php echo e(static_asset('assets/js/hummingbird-treeview.js')); ?>"></script>

<script type="text/javascript">
    $(document).ready(function (){
        show_hide_shipping_div();

        $("#treeview").hummingbird();
        var main_id = '<?php echo e($product->category_id != null ? $product->category_id : 0); ?>';
        var selected_ids = '<?php echo e(implode(",",$old_categories)); ?>';
        if (selected_ids != '') {
            const myArray = selected_ids.split(",");
            for (let i = 0; i < myArray.length; i++) {
                const element = myArray[i];
                $('#treeview input:checkbox#'+element).prop('checked',true);
                if(i < myArray.length - 1){
                    const $checkbox = $('#treeview input:checkbox#'+element);

                    $checkbox.attr('onclick', 'cursor_not_allowed(event)');
                    $checkbox.css('cursor', 'not-allowed');
                    $checkbox.closest('label').css('cursor', 'not-allowed');
                } else {
                    const $checkbox = $('#treeview input:checkbox#'+element);
                    $checkbox.closest('ul').find('input[type="checkbox"]').removeAttr('onclick');
                    $checkbox.closest('ul').find('input[type="checkbox"]').css('cursor', '');
                    $checkbox.closest('ul').find('label').css('cursor', '');
                }
                $('#treeview input:checkbox#'+element).parents( "ul" ).css( "display", "block" );
                $('#treeview input:checkbox#'+element).parents( "li" ).children('.las').removeClass( "la-plus" ).addClass('la-minus');
            }
        }
        $('#treeview input:radio[value='+main_id+']').prop('checked',true).trigger('change');
        $('#treeview input:radio[value=' + main_id + ']').next('ul').css("display", "block");

        fq_bought_product_selection_type();

    });

    $("[name=shipping_type]").on("change", function (){
        show_hide_shipping_div();
    });

    function show_hide_shipping_div() {
        var shipping_val = $("[name=shipping_type]:checked").val();

        $(".flat_rate_shipping_div").hide();

        if(shipping_val == 'flat_rate'){
            $(".flat_rate_shipping_div").show();
        }
    }

    function add_more_customer_choice_option(i, name){
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type:"POST",
            url:'<?php echo e(route('products.add-more-choice-option')); ?>',
            data:{
               attribute_id: i
            },
            success: function(data) {
                var obj = JSON.parse(data);
                $('#customer_choice_options').append('\
                <div class="form-group row">\
                    <div class="col-md-3">\
                        <input type="hidden" name="choice_no[]" value="'+i+'">\
                        <input type="text" class="form-control" name="choice[]" value="'+name+'" placeholder="<?php echo e(translate('Choice Title')); ?>" readonly>\
                    </div>\
                    <div class="col-md-8">\
                        <select class="form-control aiz-selectpicker attribute_choice" data-live-search="true" name="choice_options_'+ i +'[]" data-selected-text-format="count" multiple>\
                            '+obj+'\
                        </select>\
                    </div>\
                </div>');
                AIZ.plugins.bootstrapSelect('refresh');
           }
       });


    }

    $('input[name="colors_active"]').on('change', function() {
        if(!$('input[name="colors_active"]').is(':checked')){
            $('#colors').prop('disabled', true);
            AIZ.plugins.bootstrapSelect('refresh');
        }
        else{
            $('#colors').prop('disabled', false);
            AIZ.plugins.bootstrapSelect('refresh');
        }
        update_sku();
    });

    $(document).on("change", ".attribute_choice",function() {
        update_sku();
    });

    $('#colors').on('change', function() {
        update_sku();
    });

    function delete_row(em){
        $(em).closest('.form-group').remove();
        update_sku();
    }

    function delete_variant(em){
        $(em).closest('.variant').remove();
    }

    function update_sku(){
        $.ajax({
           type:"POST",
           url:'<?php echo e(route('products.sku_combination_edit')); ?>',
           data:$('#choice_form').serialize(),
           success: function(data){
                $('#sku_combination').html(data);
                setTimeout(() => {
                        AIZ.uploader.previewGenerate();
                }, "2000");
                if (data.trim().length > 1) {
                    $('#show-hide-div').hide();
                    AIZ.plugins.sectionFooTable('#sku_combination');
                }
                else {
                    $('#show-hide-div').show();
                }
           }
        });
    }

    AIZ.plugins.tagify();

    $(document).ready(function(){
        update_sku();

        $('.remove-files').on('click', function(){
            $(this).parents(".col-md-4").remove();
        });
    });

    $('#choice_attributes').on('change', function() {
        $.each($("#choice_attributes option:selected"), function(j, attribute){
            flag = false;
            $('input[name="choice_no[]"]').each(function(i, choice_no) {
                if($(attribute).val() == $(choice_no).val()){
                    flag = true;
                }
            });
            if(!flag){
                add_more_customer_choice_option($(attribute).val(), $(attribute).text());
            }
        });

        var str = <?php echo $product->attributes ?>;

        $.each(str, function(index, value){
            flag = false;
            $.each($("#choice_attributes option:selected"), function(j, attribute){
                if(value == $(attribute).val()){
                    flag = true;
                }
            });
            if(!flag){
                $('input[name="choice_no[]"][value="'+value+'"]').parent().parent().remove();
            }
        });

        update_sku();
    });

    function fq_bought_product_selection_type(){
        var productSelectionType = $("input[name='frequently_bought_selection_type']:checked").val();
        if(productSelectionType == 'product'){
            $('.fq_bought_select_product_div').removeClass('d-none');
            $('.fq_bought_select_category_div').addClass('d-none');
        }
        else if(productSelectionType == 'category'){
            $('.fq_bought_select_category_div').removeClass('d-none');
            $('.fq_bought_select_product_div').addClass('d-none');
        }
    }

    function showFqBoughtProductModal() {
        $('#fq-bought-product-select-modal').modal('show', {backdrop: 'static'});
    }

    function filterFqBoughtProduct() {
        var productID = $('input[name=id]').val();
        var searchKey = $('input[name=search_keyword]').val();
        var fqBroughCategory = $('select[name=fq_brough_category]').val();
        $.post('<?php echo e(route('product.search')); ?>', { _token: AIZ.data.csrf, product_id: productID, search_key:searchKey, category:fqBroughCategory, product_type:"physical" }, function(data){
            $('#product-list').html(data);
            AIZ.plugins.sectionFooTable('#product-list');
        });
    }

    function addFqBoughtProduct() {
        var selectedProducts = [];
        $("input:checkbox[name=fq_bought_product_id]:checked").each(function() {
            selectedProducts.push($(this).val());
        });

        var fqBoughtProductIds = [];
        $("input[name='fq_bought_product_ids[]']").each(function() {
            fqBoughtProductIds.push($(this).val());
        });

        var productIds = selectedProducts.concat(fqBoughtProductIds.filter((item) => selectedProducts.indexOf(item) < 0))

        $.post('<?php echo e(route('get-selected-products')); ?>', { _token: AIZ.data.csrf, product_ids:productIds}, function(data){
            $('#fq-bought-product-select-modal').modal('hide');
            $('#selected-fq-bought-products').html(data);
            AIZ.plugins.sectionFooTable('#selected-fq-bought-products');
        });
    }

    // Warranty
    function warrantySelection(){
        if($('input[name="has_warranty"]').is(':checked')) {
            $('.warranty_selection_div').removeClass('d-none');
            $('#warranty_id').attr('required', true);
        }
        else {
            $('.warranty_selection_div').addClass('d-none');
            $('#warranty_id').removeAttr('required');
        }
    }

    // Refundable
    function isRefundable() {
        const refundType = "<?php echo e(get_setting('refund_type')); ?>";
        const $refundable = $('input[name="refundable"]');
        const $mainCategoryRadio = $('input[name="category_id"]:checked');
        const $note = $('#refundable-note');

        $refundable.off('change.isRefundableLock');

        if (refundType !== 'category_based_refund') {
            $refundable.prop('disabled', false);
            $note.addClass('d-none');
            $('.refund-block').toggleClass('d-none', !$refundable.is(':checked'));
            return;
        }

        if (!$mainCategoryRadio.length) {
            $refundable.prop('checked', false);
            $refundable.prop('disabled', true);
            $('.refund-block').addClass('d-none');
            $note.text('<?php echo e(translate("Your refund type is category based. At first select the main category.")); ?>')
                .removeClass('d-none');
            return;
        }

        const categoryId = $mainCategoryRadio.val();
        $.ajax({
            type: 'POST',
            url: '<?php echo e(route("admin.products.check_refundable_category")); ?>',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                category_id: categoryId
            },
            success: function (response) {
                if (response.status === 'success' && response.is_refundable) {
                    $refundable.prop('disabled', false);
                    $note.text('<?php echo e(translate("This product allows refunds.")); ?>')
                        .removeClass('d-none');
                    $refundable.on('change.isRefundableLock', function () {
                        if (!$refundable.is(':checked')) {
                            $('.refund-block').addClass('d-none');
                        } else {
                            $('.refund-block').removeClass('d-none');
                        }
                    });
                } else {
                    $refundable.prop('checked', false);
                    $refundable.prop('disabled', true);
                    $('.refund-block').addClass('d-none');
                    $note.text('<?php echo e(translate("Selected main category has no refund. Select a refundable category.")); ?>')
                        .removeClass('d-none');
                }
            },
            error: function () {
                $refundable.prop('checked', false);
                $refundable.prop('disabled', true);
                $('.refund-block').addClass('d-none');
                $note.text('<?php echo e(translate("Could not verify category refund status.")); ?>')
                    .removeClass('d-none');
            }
        });
    }

    
    function noteModal(noteType){
        $.post('<?php echo e(route('get_notes')); ?>',{_token:'<?php echo e(@csrf_token()); ?>', note_type: noteType}, function(data){
            $('#note_modal #note_modal_content').html(data);
            $('#note_modal').modal('show', {backdrop: 'static'});
        });
    }

    function addNote(noteId, noteType){
        var noteDescription = $('#note_description_'+ noteId).val();
        $('#'+noteType+'_note_id').val(noteId);
        $('#'+noteType+'_note').html(noteDescription);
        $('#'+noteType+'_note').addClass('border border-gray my-2 p-2');
        $('#note_modal').modal('hide');
    }

</script>

<script>
    $(document).ready(function(){
        var hash = document.location.hash;
        if (hash) {
            $('.nav-tabs a[href="'+hash+'"]').tab('show');
            $('#tab').val(location.hash.substr(1));
        }else{
            $('.nav-tabs a[href="#general"]').tab('show');
            $('#tab').val('general');
        }

        // Change hash for page-reload
        $('.nav-tabs a').on('shown.bs.tab', function (e) {
            window.location.hash = e.target.hash;
        });
    });

    function submitFormWithTab(){
        var hash = document.location.hash;
        if (hash) {
            $('#tab').val(location.hash.substr(1));
        }else{
            $('#tab').val('');
        }
        $('#choice_form').submit();
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {
        warrantySelection();
        isRefundable();

        $(document).on('change', 'input[name="category_id"]', function () {
            isRefundable();
        });

        $('input[name="refundable"]').on('change', function () {
            if (!$('input[name="refundable"]').prop('disabled')) {
                $('.refund-block').toggleClass('d-none', !$(this).is(':checked'));
            }
        });
    });
</script>

<!-- سكربت التحقق من القياس -->
<script type="text/javascript">
    <?php if(isset($categories)): ?>
        let categories = <?php echo json_encode($categories, 15, 512) ?>;
    <?php else: ?>
        let categories = [];
    <?php endif; ?>

    let currentCategoryId = '<?php echo e($product->category_id); ?>';
    let measurementRange = { min: 0, max: Infinity };

    function findCategory(arr, id) {
        for (let i = 0; i < arr.length; i++) {
            if (arr[i].id == id) return arr[i];
            if (arr[i].children_categories) {
                let found = findCategory(arr[i].children_categories, id);
                if (found) return found;
            }
        }
        return null;
    }

    function getCategoryRange() {
        const selected = $('input[name="category_id"]:checked').first();
        let categoryId = selected.length > 0 ? selected.val() : currentCategoryId;
        
        if (!categoryId) return;
        
        let category = findCategory(categories, categoryId);
        if (category) {
            measurementRange.min = parseFloat(category.measurement_starts_from) || 0;
            measurementRange.max = parseFloat(category.measurement_ends_from) || Infinity;
        }
    }

    function checkMeasurement() {
        let input = $('#measurement-input');
        if (!input.length) return true;
        
        let value = parseFloat(input.val());
        let errorDiv = $('#measurement-error');
        
        getCategoryRange();
        
        if (measurementRange.min > 0 || measurementRange.max < Infinity) {
            if (value < measurementRange.min || value > measurementRange.max) {
                errorDiv.text(`<?php echo e(translate("Measurement must be between")); ?> ${measurementRange.min} - ${measurementRange.max} <?php echo e(translate("grams")); ?>`).show();
                input.addClass('is-invalid');
                return false;
            }
        }
        
        errorDiv.hide();
        input.removeClass('is-invalid');
        return true;
    }

    $(document).ready(function() {
        $('input[name="category_id"]').on('change', function() {
            checkMeasurement();
        });
        
        $('#measurement-input').on('keyup change', function() {
            checkMeasurement();
        });
        
        $('#product-form').on('submit', function(e) {
            if (!checkMeasurement()) {
                e.preventDefault();
            }
        });

        setTimeout(checkMeasurement, 500);
    });
</script>

<style>
    /* Clean Border Design */
    .page-content {
        background: #f8fafc;
        min-height: 100vh;
    }
    
    .aiz-titlebar {
        background: white;
        border-radius: 12px;
        margin-bottom: 24px;
        padding: 20px 24px !important;
        border: 1px solid #e2e8f0;
    }
    
    .icon-container {
        width: 48px;
        height: 48px;
        background: #f7fafc;
        border: 1px solid #e2e8f0;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Language Card */
    .language-card {
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        overflow: hidden;
        background: white;
        margin-bottom: 24px;
    }
    
    .language-bar .nav-link {
        transition: all 0.3s ease;
        position: relative;
        border: none !important;
        background: #f8fafc;
    }
    
    .language-bar .nav-link.active {
        color: #3498db !important;
        font-weight: 600;
        background: white;
        border-top: 2px solid #3498db !important;
    }
    
    .language-bar .nav-link:hover:not(.active) {
        background: #edf2f7;
    }
    
    /* Main Content Area */
    .bg-white {
        background: white !important;
        border-radius: 12px;
        border: 1px solid #e2e8f0;
    }
    
    /* Section Headers */
    .section-header {
        position: relative;
        padding-left: 0;
        margin-bottom: 24px;
    }
    
    .section-icon {
        width: 40px;
        height: 40px;
        background: #f7fafc;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Form Controls */
    .input-group-modern {
        border-radius: 8px;
        overflow: hidden;
        border: 1px solid #e2e8f0;
        transition: all 0.3s ease;
    }
    
    .input-group-modern .form-control {
        border: none;
        padding: 10px 15px;
        transition: all 0.3s ease;
        background: white;
        width: 100%;
    }
    
    .input-group-modern .form-control:focus {
        box-shadow: none;
        outline: none;
    }
    
    .input-group-modern:focus-within {
        border-color: #3498db;
        box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
    }
    
    /* Select Controls */
    .aiz-selectpicker {
        border: 1px solid #e2e8f0 !important;
        border-radius: 8px;
        padding: 8px 12px;
        width: 100%;
    }
    
    .aiz-selectpicker:focus {
        border-color: #3498db !important;
        box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1) !important;
        outline: none;
    }
    
    /* Category Card */
    .category-card {
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        height: 100%;
        background: white;
    }
    
    .category-card .card-header {
        background: #f8fafc;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .category-tree-container {
        background: #f8fafc;
        border-radius: 8px;
        padding: 12px;
        border: 1px solid #e2e8f0;
    }
    
    .category-item {
        padding: 4px 8px;
        border-radius: 4px;
        transition: background-color 0.2s ease;
    }
    
    .category-item:hover {
        background-color: #edf2f7;
    }
    
    /* Text Editor */
    .border-light {
        border: 1px solid #e2e8f0 !important;
        border-radius: 8px;
    }
    
    /* Upload Cards */
    .upload-card {
        border: 2px dashed #cbd5e0;
        border-radius: 12px;
        background: #f8fafc;
        transition: all 0.3s ease;
        overflow: hidden;
    }
    
    .upload-card:hover {
        border-color: #3498db;
        background: #f0f9ff;
    }
    
    .upload-area {
        padding: 40px 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
    }
    
    .upload-icon {
        margin-bottom: 15px;
        opacity: 0.7;
    }
    
    /* Buttons */
    .btn-success {
        background: #38a169;
        border: none;
        border-radius: 8px;
        padding: 12px 30px;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-success:hover {
        background: #2f855a;
        transform: translateY(-1px);
    }
    
    .btn-outline-primary, .btn-outline-secondary {
        border-radius: 6px;
        padding: 6px 16px;
        border: 1px solid;
    }
    
    .btn-outline-primary {
        border-color: #3498db;
        color: #3498db;
    }
    
    .btn-outline-secondary {
        border-color: #a0aec0;
        color: #4a5568;
    }
    
    /* Alert */
    .alert-modern {
        border: none;
        border-radius: 8px;
        background: #fff5f5;
        border-left: 4px solid #f56565;
        color: #742a2a;
    }
    
    /* Divider */
    .border-top-light {
        border-top: 1px solid #e2e8f0 !important;
    }
    
    /* Form Labels */
    .form-label {
        color: #2d3748;
        display: block;
    }
    
    .text-muted {
        color: #718096 !important;
    }
    
    /* Remove old dashed borders */
    [style*="border-bottom: 1px dashed #e4e5eb;"] {
        border-bottom: none !important;
    }
    
    /* Scrollbar */
    .c-scrollbar-light::-webkit-scrollbar {
        width: 6px;
    }
    
    .c-scrollbar-light::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    
    .c-scrollbar-light::-webkit-scrollbar-thumb {
        background: #cbd5e0;
        border-radius: 10px;
    }
    
    .c-scrollbar-light::-webkit-scrollbar-thumb:hover {
        background: #a0aec0;
    }
    
    /* Spacing */
    .form-group-row {
        margin-bottom: 20px;
    }
    
    /* File Preview */
    .file-preview.box.sm {
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 15px;
        background: #f8fafc;
    }
    
    /* Fix for original form-group row */
    .form-group.row {
        margin-bottom: 20px;
    }
    
    .col-from-label {
        padding-top: calc(0.375rem + 1px);
        padding-bottom: calc(0.375rem + 1px);
        margin-bottom: 0;
        font-size: inherit;
        line-height: 1.5;
    }

    /* أنماط التحقق من القياس */
    .is-invalid {
        border-color: #f56565 !important;
    }
    
    #measurement-error {
        font-size: 12px;
        color: #f56565;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/goldqurosh/public_html/resources/views/backend/product/products/edit.blade.php ENDPATH**/ ?>