

<?php $__env->startSection('content'); ?>
    <style>
        #section_featured .slick-slider .slick-list{
            background: #fff;
        }
        #section_featured .slick-slider .slick-list .slick-slide,
        #section_best_selling .slick-slider .slick-list .slick-slide,
        #section_newest .slick-slider .slick-list .slick-slide {
            margin-bottom: -5px;
        }
        #section_newest_preorder_products .slick-slider .slick-list .slick-slide {
            margin-bottom: -5px;
        }
        #section_featured_preorder_products .slick-slider .slick-list .slick-slide {
            margin-bottom: -5px;
        }
        .hov-animate-outline:hover::before,
        .hov-animate-outline:hover::after {
            width: calc(100% - 2px);
        }
        @media (max-width: 575px){
            #section_featured .slick-slider .slick-list .slick-slide {
                margin-bottom: -4px;
            }
        }
        @media (min-width: 992px) {
            .aiz-count-down-box-div{
                position: absolute;
                top: 70%;
                left: 50%;
                -webkit-transform: translate(-50%, -50%);
                transform: translate(-50%, -50%);
            }
        }
    </style>

    <?php $lang = get_system_language()->code;  ?>

    <!-- Featured Categories -->
    <?php if(count($featured_categories) > 0): ?>
        <section class="mb-3 mb-md-4 pt-3 pt-md-2rem">
            <div class="container">
                <!-- Categories -->
                <div class="bg-white px-sm-3">
                    <div class="aiz-carousel sm-gutters-17" data-items="8" data-xxl-items="8" data-xl-items="8"
                        data-lg-items="6" data-md-items="5" data-sm-items="3" data-xs-items="2" data-arrows="true"
                        data-dots="false" data-autoplay="false" data-infinite="true" data-center="false">
                        <?php $__currentLoopData = $featured_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $category_name = $category->getTranslation('name');
                            ?>
                            <div class="carousel-box px-4 d-flex flex-column align-items-center">
                                <div class="size-80px overflow-hidden hov-scale-img">
                                    <a class="d-block" href="<?php echo e(route('products.category', $category->slug)); ?>">
                                        <img src="<?php echo e(isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg')); ?>"
                                            class="lazyload img-fit h-100 mx-auto has-transition"
                                            alt="<?php echo e($category->getTranslation('name')); ?>"
                                            onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                    </a>
                                </div>
                                <div class="text-center h-35px text-truncate-2" style="margin-top: 12px;">
                                    <a class="fs-13 fw-500 text-center text-reset hov-text-primary"
                                        href="<?php echo e(route('products.category', $category->slug)); ?>"
                                        style="width: max-content;">
                                        <?php echo e($category_name); ?>

                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Sliders -->
    <div class="home-banner-area mb-3" style="background-color: <?php echo e(get_setting('slider_section_bg_color', '#dedede')); ?>">
        <div class="<?php if(get_setting('slider_section_full_width') == 1): ?> p-0 <?php else: ?> container <?php endif; ?>">
            <!-- Sliders -->
            <div class="home-slider slider-full">
                <?php if(get_setting('home_slider_images', null, $lang) != null): ?>
                    <div class="aiz-carousel dots-inside-bottom mobile-img-auto-height" data-autoplay="true" data-infinite="true">
                        <?php
                            $decoded_slider_images = json_decode(get_setting('home_slider_images', null, $lang), true);
                            $sliders = get_slider_images($decoded_slider_images);
                            $home_slider_links = get_setting('home_slider_links', null, $lang);
                        ?>
                        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-box">
                                <a href="<?php echo e(isset(json_decode($home_slider_links, true)[$key]) ? json_decode($home_slider_links, true)[$key] : ''); ?>">
                                    <!-- Image -->
                                    <div class="d-block mw-100 img-fit overflow-hidden h-180px h-sm-200px h-md-250px h-lg-300px h-xl-370px overflow-hidden">
                                        <img class="img-fit h-100 m-auto has-transition ls-is-cached lazyloaded"
                                        src="<?php echo e($slider ? my_asset($slider->file_name) : static_asset('assets/img/placeholder.jpg')); ?>"
                                        alt="<?php echo e(env('APP_NAME')); ?> promo"
                                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Flash Deal -->
    <?php
        $flash_deal = get_featured_flash_deal();
        $flash_deal_bg = get_setting('flash_deal_bg_color');
        $flash_deal_bg_full_width = (get_setting('flash_deal_bg_full_width') == 1) ? true : false;
        $flash_deal_banner_menu_text = ((get_setting('flash_deal_banner_menu_text') == 'dark') ||  (get_setting('flash_deal_banner_menu_text') == null)) ? 'text-dark' : 'text-white';

    ?>
    <?php if($flash_deal != null): ?>
        <section class="mb-2 mb-md-3 mt-2 mt-md-3" style="background: <?php echo e(($flash_deal_bg_full_width && $flash_deal_bg != null) ? $flash_deal_bg : ''); ?>;" id="flash_deal">
            <div class="container">
                <div class="<?php if(!$flash_deal_bg_full_width): ?> px-3 px-md-2rem <?php endif; ?> pb-3 pb-md-4" style="background: <?php echo e($flash_deal_bg != null ? $flash_deal_bg : '#faf9f7'); ?>;">
                    <!-- Top Section -->
                    <div class="d-flex flex-wrap align-items-baseline justify-content-center justify-content-sm-between mb-2 mb-md-3 pt-2 pt-md-3 position-relative">
                        <!-- Title -->
                        <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                            <span class="d-inline-block <?php echo e($flash_deal_banner_menu_text); ?>"><?php echo e(translate('Flash Sale')); ?></span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="24" viewBox="0 0 16 24"
                                class="ml-3">
                                <path id="Path_28795" data-name="Path 28795"
                                    d="M30.953,13.695a.474.474,0,0,0-.424-.25h-4.9l3.917-7.81a.423.423,0,0,0-.028-.428.477.477,0,0,0-.4-.207H21.588a.473.473,0,0,0-.429.263L15.041,18.151a.423.423,0,0,0,.034.423.478.478,0,0,0,.4.2h4.593l-2.229,9.683a.438.438,0,0,0,.259.5.489.489,0,0,0,.571-.127L30.9,14.164a.425.425,0,0,0,.054-.469Z"
                                    transform="translate(-15 -5)" fill="#fcc201" />
                            </svg>
                        </h3>
                        <!-- Countdown -->
                        <div class="aiz-count-down-box-div">
                            <div class="aiz-count-down-box align-items-center mb-2 mb-lg-0" data-date="<?php echo e(date('Y/m/d H:i:s', $flash_deal->end_date)); ?>"></div>
                        </div>
                        <!-- Links -->
                        <div>
                            <div class="text-dark d-flex align-items-center mb-0">
                                <a href="<?php echo e(route('flash-deals')); ?>"
                                    class="fs-10 fs-md-12 fw-700 has-transition <?php if((get_setting('flash_deal_banner_menu_text') == 'light') && $flash_deal_bg_full_width && $flash_deal_bg != null): ?> text-white opacity-60 hov-opacity-100 animate-underline-white <?php else: ?> text-reset opacity-60 hov-opacity-100 hov-text-primary animate-underline-primary <?php endif; ?> mr-3"><?php echo e(translate('View All Flash Sale')); ?></a>
                                <span class=" border-left border-soft-light border-width-2 pl-3">
                                    <a href="<?php echo e(route('flash-deal-details', $flash_deal->slug)); ?>"
                                        class="fs-10 fs-md-12 fw-700 has-transition <?php if((get_setting('flash_deal_banner_menu_text') == 'light') && $flash_deal_bg_full_width && $flash_deal_bg != null): ?> == 'light') text-white opacity-60 hov-opacity-100 animate-underline-white <?php else: ?> text-reset opacity-60 hov-opacity-100 hov-text-primary animate-underline-primary <?php endif; ?>"><?php echo e(translate('View All Products from This Flash Sale')); ?></a>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="row no-gutters align-items-center border" style="background: <?php echo e($flash_deal_bg); ?>;">
                        <!-- Flash Deals Baner -->
                        <div class="col-xxl-2 col-md-3 col-sm-4 col-5 h-150px h-md-200px h-lg-240px">
                            <a href="<?php echo e(route('flash-deal-details', $flash_deal->slug)); ?>">
                                <div class="h-100 w-100 w-xl-auto"
                                    style="background-image: url('<?php echo e(uploaded_asset($flash_deal->banner)); ?>'); background-size: cover; background-position: center center;">
                                </div>
                            </a>
                        </div>

                        <div class="col-xxl-10 col-md-9 col-sm-8 col-7">
                            <!-- Flash Deals Products -->
                            <?php
                                $flash_deal_products = get_flash_deal_products($flash_deal->id);
                            ?>
                            <div class="aiz-carousel arrow-inactive-none arrow-x-0"
                                data-items="6" data-xxl-items="6" data-xl-items="5" data-lg-items="3.7" data-md-items="3"
                                data-sm-items="2.7" data-xs-items="1.5" data-arrows="true" data-dots="false">
                                <?php $__currentLoopData = $flash_deal_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $flash_deal_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="carousel-box bg-white">
                                        <?php if($flash_deal_product->product != null && $flash_deal_product->product->published != 0): ?>
                                            <?php
                                                $product_url = route('product', $flash_deal_product->product->slug);
                                                if ($flash_deal_product->product->auction_product == 1) {
                                                    $product_url = route('auction-product', $flash_deal_product->product->slug);
                                                }
                                            ?>
                                            <div
                                                class="h-150px h-md-200px h-lg-240px flash-deal-item position-relative text-center has-transition hov-shadow-out z-1">
                                                <a href="<?php echo e($product_url); ?>"
                                                    class="d-block py-md-2 overflow-hidden hov-scale-img"
                                                    title="<?php echo e($flash_deal_product->product->getTranslation('name')); ?>">
                                                    <!-- Image -->
                                                    <div class="d-block h-100 position-relative image-hover-effect">
                                                        <img class="lazyload h-100px h-md-120px h-lg-140px mw-100 mx-auto has-transition product-main-image"
                                                            src="<?php echo e(get_image($flash_deal_product->product->thumbnail)); ?>"
                                                            alt="<?php echo e($flash_deal_product->product->getTranslation('name')); ?>"
                                                            onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                                        <img class="lazyload h-100px h-md-120px h-lg-140px w-100 mx-auto has-transition product-hover-image position-absolute"
                                                            src="<?php echo e(get_first_product_image($flash_deal_product->product->thumbnail, $flash_deal_product->product->photos)); ?>"
                                                            alt="<?php echo e($flash_deal_product->product->getTranslation('name')); ?>"
                                                            onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                                    </div>
                                                    <!-- Price -->
                                                    <div
                                                        class="fs-10 fs-md-14 mt-2 text-center h-md-48px has-transition overflow-hidden pt-md-4 flash-deal-price lh-1-5">
                                                        <span
                                                            class="d-block text-primary fw-700"><?php echo e(home_discounted_base_price($flash_deal_product->product)); ?></span>
                                                        <?php if(home_base_price($flash_deal_product->product) != home_discounted_base_price($flash_deal_product->product)): ?>
                                                            <del
                                                                class="d-block fw-400 text-secondary"><?php echo e(home_base_price($flash_deal_product->product)); ?></del>
                                                        <?php endif; ?>
                                                    </div>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Today's deal -->
    <?php
        $todays_deal_section_bg = get_setting('todays_deal_section_bg_color');
    ?>
    <div id="todays_deal" <?php if(get_setting('todays_deal_section_bg') == 1): ?> style="background: <?php echo e($todays_deal_section_bg); ?>;" <?php endif; ?>>

    </div>

    <!-- Featured Products -->
    <div id="section_featured">

    </div>


    <?php if(addon_is_activated('preorder')): ?>

    <!-- Banner section 2 -->
    <?php $homepreorder_banner_1Images = get_setting('home_preorder_banner_1_images', null, $lang);   ?>
    <?php if($homepreorder_banner_1Images != null): ?>
        <div class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                <?php
                    $banner_2_imags = json_decode($homepreorder_banner_1Images);
                    $data_md = count($banner_2_imags) >= 2 ? 2 : 1;
                    $home_preorder_banner_1_links = get_setting('home_preorder_banner_1_links', null, $lang);
                ?>
                <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                    data-items="<?php echo e(count($banner_2_imags)); ?>" data-xxl-items="<?php echo e(count($banner_2_imags)); ?>"
                    data-xl-items="<?php echo e(count($banner_2_imags)); ?>" data-lg-items="<?php echo e($data_md); ?>"
                    data-md-items="<?php echo e($data_md); ?>" data-sm-items="1" data-xs-items="1" data-arrows="true"
                    data-dots="false">
                    <?php $__currentLoopData = $banner_2_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-box overflow-hidden hov-scale-img">
                            <a href="<?php echo e(isset(json_decode($home_preorder_banner_1_links, true)[$key]) ? json_decode($home_preorder_banner_1_links, true)[$key] : ''); ?>"
                                class="d-block text-reset overflow-hidden">
                                <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                    data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                    class="img-fluid lazyload w-100 has-transition"
                                    onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>


    <!-- Featured Preorder Products -->
    <div id="section_featured_preorder_products">

    </div>
    <?php endif; ?>
 

    <!-- Banner section 2 -->
    <?php $homeBanner2Images = get_setting('home_banner2_images', null, $lang);   ?>
    <?php if($homeBanner2Images != null): ?>
        <div class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                <?php
                    $banner_2_imags = json_decode($homeBanner2Images);
                    $data_md = count($banner_2_imags) >= 2 ? 2 : 1;
                    $home_banner2_links = get_setting('home_banner2_links', null, $lang);
                ?>
                <div class="aiz-carousel gutters-16 overflow-hidden arrow-inactive-none arrow-dark arrow-x-15"
                    data-items="<?php echo e(count($banner_2_imags)); ?>" data-xxl-items="<?php echo e(count($banner_2_imags)); ?>"
                    data-xl-items="<?php echo e(count($banner_2_imags)); ?>" data-lg-items="<?php echo e($data_md); ?>"
                    data-md-items="<?php echo e($data_md); ?>" data-sm-items="1" data-xs-items="1" data-arrows="true"
                    data-dots="false">
                    <?php $__currentLoopData = $banner_2_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-box overflow-hidden hov-scale-img">
                            <a href="<?php echo e(isset(json_decode($home_banner2_links, true)[$key]) ? json_decode($home_banner2_links, true)[$key] : ''); ?>"
                                class="d-block text-reset overflow-hidden">
                                <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                    data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                    class="img-fluid lazyload w-100 has-transition"
                                    onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Best Selling, New Products, Banner section 2 -->
    <?php
        $homeBanner3Images = get_setting('home_banner3_images', null, $lang);
        $col_val = 6;
        if ($homeBanner3Images != null){
            $col_val = 4;
        }
    ?>
    <div class="container">
        <div class="row gutters-16">
            <div class="col-xl-<?php echo e($col_val); ?> mb-2 mb-md-3 mt-2 mt-md-3">
                <!-- Best Selling  -->
                <div id="section_best_selling">

                </div>
            </div>

            <div class="col-xl-<?php echo e($col_val); ?> mb-2 mb-md-3 mt-2 mt-md-3">
                <!-- New Products -->
                <div id="section_newest">

                </div>
            </div>



            <!-- Banner section 3 -->
            <?php if($homeBanner3Images != null): ?>
                <div class="col-xl-4 mb-2 mb-md-3 mt-2 mt-md-3 d-none d-xl-block">
                    <?php
                        $banner_3_imags = json_decode($homeBanner3Images);
                        $home_banner3_links = get_setting('home_banner3_links', null, $lang);
                    ?>
                    <div class="aiz-carousel overflow-hidden arrow-inactive-none arrow-dark arrow-x-0"
                        data-items="1" data-arrows="true" data-dots="false" data-autoplay="true">
                        <?php $__currentLoopData = $banner_3_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-box overflow-hidden hov-scale-img">
                                <a href="<?php echo e(isset(json_decode($home_banner3_links, true)[$key]) ? json_decode($home_banner3_links, true)[$key] : ''); ?>"
                                    class="d-block text-reset overflow-hidden" style="height: 685px;">
                                    <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                        data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                        class="img-fit h-100 lazyload has-transition"
                                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Banner section 4, Top Sellers -->
    <?php if(get_setting('vendor_system_activation') == 1): ?>
        <?php
            $best_selers = get_best_sellers(10);
            $homeBanner4Images = get_setting('home_banner4_images', null, $lang);
            $data_rows = 1;
            $xxl_items = 5;
            $xl_items = 4;
            $lg_items = 3.4;
            $md_items = 2.5;
            if ($homeBanner4Images != null){
                $data_rows = 2;
                $xxl_items = 2;
                $xl_items = 2;
                $lg_items = 2;
                $md_items = 3;
            }
        ?>
        <?php if(count($best_selers) > 0): ?>
        <section class="">
            <div class="container">
                <div class="row">
                    <!-- Banner section 4 -->
                    <?php if($homeBanner4Images != null): ?>
                        <div class="col-xl-8 col-lg-6 mb-2 mb-md-3 mt-2 mt-md-3 d-none d-lg-block">
                            <?php
                                $banner_4_imags = json_decode($homeBanner4Images);
                                $home_banner4_links = get_setting('home_banner4_links', null, $lang);
                            ?>
                            <div class="aiz-carousel overflow-hidden arrow-inactive-none arrow-dark arrow-x-0"
                                data-items="1" data-arrows="true" data-dots="false" data-autoplay="true">
                                <?php $__currentLoopData = $banner_4_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="carousel-box overflow-hidden hov-scale-img">
                                        <a href="<?php echo e(isset(json_decode($home_banner4_links, true)[$key]) ? json_decode($home_banner4_links, true)[$key] : ''); ?>"
                                            class="d-block text-reset overflow-hidden" style="height: 650px;">
                                            <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                                data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                                class="img-fit h-100 lazyload has-transition"
                                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Top Sellers -->
                    <div class="col mb-2 mb-md-3 mt-2 mt-md-3">
                        <div class="h-100" id="section_top_sellers">
                            <div class="border px-3 py-2rem">
                                <!-- Top Section -->
                                <div class="d-flex mb-3 mb-md-4 align-items-baseline justify-content-between">
                                    <!-- Title -->
                                    <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                                        <span class="pb-3"><?php echo e(translate('Top Sellers')); ?></span>
                                    </h3>
                                    <!-- Links -->
                                    <div class="d-flex">
                                        <a class="text-blue fs-10 fs-md-12 fw-700 hov-text-primary animate-underline-primary"
                                            href="<?php echo e(route('sellers')); ?>"><?php echo e(translate('View All Sellers')); ?></a>
                                    </div>
                                </div>
                                <!-- Sellers Section -->
                                <div class="aiz-carousel arrow-x-0 arrow-inactive-none" data-rows="<?php echo e($data_rows); ?>" data-items="<?php echo e($xxl_items); ?>" data-xxl-items="<?php echo e($xxl_items); ?>"
                                    data-xl-items="<?php echo e($xl_items); ?>" data-lg-items="<?php echo e($lg_items); ?>" data-md-items="<?php echo e($md_items); ?>" data-sm-items="2" data-xs-items="1.4"
                                    data-arrows="true" data-dots="false">
                                    <?php $__currentLoopData = $best_selers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($seller->user != null): ?>
                                            <div
                                                class="carousel-box h-100 position-relative text-center has-transition hov-animate-outline">
                                                <div class="position-relative px-3 px-xl-2 py-3">
                                                    <!-- Shop logo & Verification Status -->
                                                    <div class="mx-auto size-100px">
                                                        <a href="<?php echo e(route('shop.visit', $seller->slug)); ?>"
                                                            class="d-flex mx-auto justify-content-center align-item-center size-100px border overflow-hidden hov-scale-img"
                                                            tabindex="0"
                                                            style="border: 1px solid #e5e5e5; border-radius: 50%; box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.06);">
                                                            <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                                                data-src="<?php echo e(uploaded_asset($seller->logo)); ?>" alt="<?php echo e($seller->name); ?>"
                                                                class="img-fit lazyload has-transition"
                                                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                                        </a>
                                                    </div>
                                                    <!-- Shop name -->
                                                    <h2 class="fs-14 fw-700 text-dark text-truncate-2 h-40px mt-3 mt-md-4 mb-0 mb-md-3">
                                                        <a href="<?php echo e(route('shop.visit', $seller->slug)); ?>"
                                                            class="text-reset hov-text-primary" tabindex="0"><?php echo e($seller->name); ?></a>
                                                    </h2>
                                                    <!-- Shop Rating -->
                                                    <div class="rating rating-mr-2 text-dark mb-3">
                                                        <?php echo e(renderStarRating($seller->rating)); ?> <br>
                                                        <span class="opacity-60 fs-14">(<?php echo e($seller->num_of_reviews); ?>

                                                            <?php echo e(translate('Reviews')); ?>)</span>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Top Brands, Banner section 5, Banner section 6 -->
    <?php if(get_setting('top_brands') != null): ?>
        <?php
            $top_brands = json_decode(get_setting('top_brands'));
            $brands = get_brands($top_brands);
            $homeBanner5Images = get_setting('home_banner5_images', null, $lang);
            $homeBanner6Images = get_setting('home_banner6_images', null, $lang);
            $col_val = 'col-xl-4';
            $data_rows = 3;
            $xxl_items = 2;
            $xl_items = 2;
            $lg_items = 4;
            $md_items = 3;
            $sm_items = 2;
            $xs_items = 1.4;
            if ($homeBanner5Images == null && $homeBanner6Images == null){
                $data_rows = 2;
                $xxl_items = 6;
                $xl_items = 5;
            } elseif ($homeBanner5Images == null || $homeBanner6Images == null) {
                $col_val = 'col-xxl-8 col-xl-6';
                $data_rows = 3;
                $xxl_items = 2;
                $xl_items = 3;
            }
        ?>
        <section class="mb-2 mb-md-3 mt-2 mt-md-3">
            <div class="container">
                <div class="row">

                    <!-- Top Brands -->
                    <div class="col py-3 py-lg-0">
                        <div class="h-100" id="section_top_brands">
                            <div class="border px-3 pt-3">
                                <!-- Top Section -->
                                <div class="d-flex mb-3 mb-md-4 align-items-baseline justify-content-between">
                                    <!-- Title -->
                                    <h3 class="fs-16 fs-md-20 fw-700 mb-2 mb-sm-0">
                                        <span class="pb-3"><?php echo e(translate('Top Brands')); ?></span>
                                    </h3>
                                    <!-- Links -->
                                    <div class="d-flex">
                                        <a class="text-blue fs-10 fs-md-12 fw-700 hov-text-primary animate-underline-primary"
                                            href="<?php echo e(route('brands.all')); ?>"><?php echo e(translate('View All Brands')); ?></a>
                                    </div>
                                </div>
                                <!-- Brands Section -->
                                <div class="aiz-carousel arrow-x-0 arrow-inactive-none py-4" data-rows="<?php echo e($data_rows); ?>" data-items="<?php echo e($xxl_items); ?>" data-xxl-items="<?php echo e($xxl_items); ?>"
                                    data-xl-items="<?php echo e($xl_items); ?>" data-lg-items="<?php echo e($lg_items); ?>" data-md-items="<?php echo e($md_items); ?>" data-sm-items="<?php echo e($sm_items); ?>" data-xs-items="<?php echo e($xs_items); ?>"
                                    data-arrows="true" data-dots="false">
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="carousel-box position-relative text-center hov-scale-img has-transition hov-shadow-out z-1">
                                            <a href="<?php echo e(route('products.brand', $brand->slug)); ?>" class="d-block p-sm-2">
                                                <img src="<?php echo e($brand->logo != null ? uploaded_asset($brand->logo) : static_asset('assets/img/placeholder.jpg')); ?>"
                                                    class="lazyload h-100px h-md-110px mx-auto has-transition p-2 p-sm-4"
                                                    alt="<?php echo e($brand->getTranslation('name')); ?>"
                                                    onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                                <p class="text-center text-dark fs-12 fs-md-14 fw-700 mt-2 mb-2 text-truncate" title="<?php echo e($brand->getTranslation('name')); ?>">
                                                    <?php echo e($brand->getTranslation('name')); ?>

                                                </p>
                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Banner section 5 -->
                    <?php if($homeBanner5Images != null): ?>
                        <?php
                            $banner_5_imags = json_decode($homeBanner5Images);
                            $home_banner5_links = get_setting('home_banner5_links', null, $lang);
                        ?>
                        <div class="<?php echo e($col_val); ?> d-none d-xl-block">
                            <div class="aiz-carousel overflow-hidden arrow-inactive-none arrow-dark arrow-x-0"
                                data-items="1" data-arrows="true" data-dots="false" data-autoplay="true">
                                <?php $__currentLoopData = $banner_5_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="carousel-box overflow-hidden hov-scale-img">
                                        <a href="<?php echo e(isset(json_decode($home_banner5_links, true)[$key]) ? json_decode($home_banner5_links, true)[$key] : ''); ?>"
                                            class="d-block text-reset overflow-hidden" style="height: 605px;">
                                            <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                                data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                                class="img-fit h-100 lazyload has-transition"
                                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Banner section 6 -->
                    <?php if($homeBanner6Images != null): ?>
                        <?php
                            $banner_6_imags = json_decode($homeBanner6Images);
                            $home_banner6_links = get_setting('home_banner6_links', null, $lang);
                        ?>
                        <div class="<?php echo e($col_val); ?> d-none d-xl-block"><div class="aiz-carousel overflow-hidden arrow-inactive-none arrow-dark arrow-x-0"
                            data-items="1" data-arrows="true" data-dots="false" data-autoplay="true">
                                <?php $__currentLoopData = $banner_6_imags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="carousel-box overflow-hidden hov-scale-img">
                                        <a href="<?php echo e(isset(json_decode($home_banner6_links, true)[$key]) ? json_decode($home_banner6_links, true)[$key] : ''); ?>"
                                            class="d-block text-reset overflow-hidden" style="height: 605px;">
                                            <img src="<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>"
                                                data-src="<?php echo e(uploaded_asset($value)); ?>" alt="<?php echo e(env('APP_NAME')); ?> promo"
                                                class="img-fit h-100 lazyload has-transition"
                                                onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder-rect.jpg')); ?>';">
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Auction Product -->
    <?php if(addon_is_activated('auction')): ?>
        <div id="auction_products">

        </div>
    <?php endif; ?>

    <!-- Cupon -->
    <?php if(get_setting('coupon_system') == 1): ?>
        <div class="mt-2 mt-md-3 mb-2 mb-md-3">
            <div class="container">
                <div class="position-relative py-5 px-3 px-sm-4 px-lg-5" style="background-color: <?php echo e(get_setting('cupon_background_color', '#292933')); ?>">
                    <div class="text-center text-xl-left position-relative z-5">
                        <div class="d-lg-flex justify-content-lg-between">
                            <div class="order-lg-1 mb-3 mb-lg-0">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="206.12" height="175.997" viewBox="0 0 206.12 175.997">
                                    <defs>
                                      <clipPath id="clip-path">
                                        <path id="Union_10" data-name="Union 10" d="M-.008,77.361l142.979-.327-22.578.051.176-77.132L143.148-.1l-.177,77.132-.064,28.218L-.072,105.58Z" transform="translate(0 0)" fill="none" stroke="#000" stroke-width="2"/>
                                      </clipPath>
                                    </defs>
                                    <g id="Group_24326" data-name="Group 24326" transform="translate(-274.202 -5254.612)" opacity="0.5">
                                      <g id="Mask_Group_23" data-name="Mask Group 23" transform="translate(304.445 5355.902) rotate(-45)" clip-path="url(#clip-path)">
                                        <g id="Group_24322" data-name="Group 24322" transform="translate(7.681 5.856)">
                                          <g id="Subtraction_167" data-name="Subtraction 167" transform="translate(0 0)" fill="none">
                                            <path d="M127.451,90.3H8a8.009,8.009,0,0,1-8-8V60.2a14.953,14.953,0,0,0,10.642-4.408A14.951,14.951,0,0,0,15.05,45.15a14.953,14.953,0,0,0-4.408-10.643A14.951,14.951,0,0,0,0,30.1V8A8.009,8.009,0,0,1,8,0H127.451a8.009,8.009,0,0,1,8,8V29.79a15.05,15.05,0,1,0,0,30.1V82.3A8.009,8.009,0,0,1,127.451,90.3Z" stroke="none"/>
                                            <path d="M 127.450813293457 88.30060577392578 C 130.75927734375 88.30060577392578 133.4509124755859 85.60896301269531 133.4509124755859 82.30050659179688 L 133.4508972167969 61.77521514892578 C 129.6533966064453 61.33430480957031 126.1383361816406 59.64068222045898 123.394172668457 56.89652252197266 C 120.1737594604492 53.67610168457031 118.4001998901367 49.39426422119141 118.4001998901367 44.83980178833008 C 118.4001998901367 40.28572463989258 120.1737747192383 36.0041618347168 123.3942184448242 32.78384399414062 C 126.1376495361328 30.04052734375 129.6527099609375 28.34706115722656 133.4509124755859 27.9056282043457 L 133.4509124755859 8.000102996826172 C 133.4509124755859 4.691642761230469 130.75927734375 2.000002861022949 127.450813293457 2.000002861022949 L 8.000096321105957 2.000002861022949 C 4.691636085510254 2.000002861022949 1.999996185302734 4.691642761230469 1.999996185302734 8.000102996826172 L 1.999996185302734 28.21491050720215 C 5.797210216522217 28.65582466125488 9.31190013885498 30.34944725036621 12.05595588684082 33.09362411499023 C 15.27627658843994 36.31408309936523 17.04979705810547 40.59588241577148 17.04979705810547 45.15030288696289 C 17.04979705810547 49.70434188842773 15.27627658843994 53.98588180541992 12.05591583251953 57.20624160766602 C 9.312583923339844 59.94955825805664 5.797909259796143 61.64302062988281 1.999996185302734 62.08445739746094 L 1.999996185302734 82.30050659179688 C 1.999996185302734 85.60896301269531 4.691636085510254 88.30060577392578 8.000096321105957 88.30060577392578 L 127.450813293457 88.30060577392578 M 127.450813293457 90.30060577392578 L 8.000096321105957 90.30060577392578 C 3.588836193084717 90.30060577392578 -3.762207143154228e-06 86.71176147460938 -3.762207143154228e-06 82.30050659179688 L -3.762207143154228e-06 60.20010375976562 C 4.022176265716553 60.19910430908203 7.799756050109863 58.63396453857422 10.64171600341797 55.79202270507812 C 13.48431587219238 52.94942474365234 15.04979610443115 49.17012405395508 15.04979610443115 45.15030288696289 C 15.04979610443115 41.13010406494141 13.48431587219238 37.35052108764648 10.64171600341797 34.5078010559082 C 7.799176216125488 31.66514205932617 4.019876003265381 30.0996036529541 -3.762207143154228e-06 30.0996036529541 L -3.762207143154228e-06 8.000102996826172 C -3.762207143154228e-06 3.588842868804932 3.588836193084717 2.886962874981691e-06 8.000096321105957 2.886962874981691e-06 L 127.450813293457 2.886962874981691e-06 C 131.8620758056641 2.886962874981691e-06 135.4509124755859 3.588842868804932 135.4509124755859 8.000102996826172 L 135.4509124755859 29.79000282287598 C 131.4283294677734 29.79100227355957 127.6504745483398 31.35614204406738 124.8083953857422 34.19808197021484 C 121.9657363891602 37.04064178466797 120.4001998901367 40.81994247436523 120.4001998901367 44.83980178833008 C 120.4001998901367 48.86006164550781 121.9657363891602 52.63964462280273 124.8083953857422 55.48230361938477 C 127.6510543823242 58.3249626159668 131.4306488037109 59.8905029296875 135.4508972167969 59.8905029296875 L 135.4509124755859 82.30050659179688 C 135.4509124755859 86.71176147460938 131.8620758056641 90.30060577392578 127.450813293457 90.30060577392578 Z" stroke="none" fill="#000"/>
                                          </g>
                                        </g>
                                      </g>
                                      <g id="Group_24321" data-name="Group 24321" transform="translate(274.202 5357.276) rotate(-45)">
                                        <g id="Subtraction_167-2" data-name="Subtraction 167" transform="translate(0 0)" fill="none">
                                          <path d="M127.451,90.3H8a8.009,8.009,0,0,1-8-8V60.2a14.953,14.953,0,0,0,10.642-4.408A14.951,14.951,0,0,0,15.05,45.15a14.953,14.953,0,0,0-4.408-10.643A14.951,14.951,0,0,0,0,30.1V8A8.009,8.009,0,0,1,8,0H127.451a8.009,8.009,0,0,1,8,8V29.79a15.05,15.05,0,1,0,0,30.1V82.3A8.009,8.009,0,0,1,127.451,90.3Z" stroke="none"/>
                                          <path d="M 127.450813293457 88.30060577392578 C 130.75927734375 88.30060577392578 133.4509124755859 85.60896301269531 133.4509124755859 82.30050659179688 L 133.4508972167969 61.77521514892578 C 129.6533966064453 61.33430480957031 126.1383361816406 59.64068222045898 123.394172668457 56.89652252197266 C 120.1737594604492 53.67610168457031 118.4001998901367 49.39426422119141 118.4001998901367 44.83980178833008 C 118.4001998901367 40.28572463989258 120.1737747192383 36.0041618347168 123.3942184448242 32.78384399414062 C 126.1376495361328 30.04052734375 129.6527099609375 28.34706115722656 133.4509124755859 27.9056282043457 L 133.4509124755859 8.000102996826172 C 133.4509124755859 4.691642761230469 130.75927734375 2.000002861022949 127.450813293457 2.000002861022949 L 8.000096321105957 2.000002861022949 C 4.691636085510254 2.000002861022949 1.999996185302734 4.691642761230469 1.999996185302734 8.000102996826172 L 1.999996185302734 28.21491050720215 C 5.797210216522217 28.65582466125488 9.31190013885498 30.34944725036621 12.05595588684082 33.09362411499023 C 15.27627658843994 36.31408309936523 17.04979705810547 40.59588241577148 17.04979705810547 45.15030288696289 C 17.04979705810547 49.70434188842773 15.27627658843994 53.98588180541992 12.05591583251953 57.20624160766602 C 9.312583923339844 59.94955825805664 5.797909259796143 61.64302062988281 1.999996185302734 62.08445739746094 L 1.999996185302734 82.30050659179688 C 1.999996185302734 85.60896301269531 4.691636085510254 88.30060577392578 8.000096321105957 88.30060577392578 L 127.450813293457 88.30060577392578 M 127.450813293457 90.30060577392578 L 8.000096321105957 90.30060577392578 C 3.588836193084717 90.30060577392578 -3.762207143154228e-06 86.71176147460938 -3.762207143154228e-06 82.30050659179688 L -3.762207143154228e-06 60.20010375976562 C 4.022176265716553 60.19910430908203 7.799756050109863 58.63396453857422 10.64171600341797 55.79202270507812 C 13.48431587219238 52.94942474365234 15.04979610443115 49.17012405395508 15.04979610443115 45.15030288696289 C 15.04979610443115 41.13010406494141 13.48431587219238 37.35052108764648 10.64171600341797 34.5078010559082 C 7.799176216125488 31.66514205932617 4.019876003265381 30.0996036529541 -3.762207143154228e-06 30.0996036529541 L -3.762207143154228e-06 8.000102996826172 C -3.762207143154228e-06 3.588842868804932 3.588836193084717 2.886962874981691e-06 8.000096321105957 2.886962874981691e-06 L 127.450813293457 2.886962874981691e-06 C 131.8620758056641 2.886962874981691e-06 135.4509124755859 3.588842868804932 135.4509124755859 8.000102996826172 L 135.4509124755859 29.79000282287598 C 131.4283294677734 29.79100227355957 127.6504745483398 31.35614204406738 124.8083953857422 34.19808197021484 C 121.9657363891602 37.04064178466797 120.4001998901367 40.81994247436523 120.4001998901367 44.83980178833008 C 120.4001998901367 48.86006164550781 121.9657363891602 52.63964462280273 124.8083953857422 55.48230361938477 C 127.6510543823242 58.3249626159668 131.4306488037109 59.8905029296875 135.4508972167969 59.8905029296875 L 135.4509124755859 82.30050659179688 C 135.4509124755859 86.71176147460938 131.8620758056641 90.30060577392578 127.450813293457 90.30060577392578 Z" stroke="none" fill="#000"/>
                                        </g>
                                        <g id="Group_24325" data-name="Group 24325" transform="translate(26.233 43.075)">
                                          <path id="Path_41600" data-name="Path 41600" d="M.006.024,15.056-.01l-.009,3.763L0,3.787Z" transform="translate(22.575 0.058)"/>
                                          <path id="Path_41601" data-name="Path 41601" d="M.006.024,15.056-.01l-.009,3.763L0,3.787Z" transform="translate(45.151 0.006)"/>
                                          <path id="Path_41602" data-name="Path 41602" d="M.006.024,15.056-.01l-.009,3.763L0,3.787Z" transform="translate(67.725 -0.046)"/>
                                          <path id="Path_41603" data-name="Path 41603" d="M.006.024,15.056-.01l-.009,3.763L0,3.787Z" transform="translate(0 0.11)"/>
                                        </g>
                                      </g>
                                    </g>
                                </svg>
                            </div>
                            <div class="">
                                <h5 class="fs-36 fw-400 text-dark mb-3"><?php echo e(translate(get_setting('cupon_title'))); ?></h5>
                                <h5 class="fs-20 fw-400 text-dark"><?php echo e(translate(get_setting('cupon_subtitle'))); ?></h5>
                                <div class="mt-5">
                                    <a href="<?php echo e(route('coupons.all')); ?>"
                                        class="btn btn-dark fs-16 px-5 rounded-4"
                                        style="box-shadow: 0px 20px 30px rgba(0, 0, 0, 0.16);"><?php echo e(translate('View All Coupons')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Classified Product -->
    <?php if(get_setting('classified_product') == 1): ?>
        <?php
            $classified_products = get_home_page_classified_products(6);
        ?>
        <?php if(count($classified_products) > 0): ?>
            <section class="py-3" style="">
                <div class="container">
                    <div class="border">
                        <!-- Top Section -->
                        <div class="d-flex p-3 p-sm-4 align-items-baseline justify-content-between">
                            <!-- Title -->
                            <h3 class="fs-16 fs-md-20 fw-700 mb-0">
                                <span class=""><?php echo e(translate('Classified Ads')); ?></span>
                            </h3>
                            <!-- Links -->
                            <div class="d-flex">
                                <a class="text-blue fs-10 fs-md-12 fw-700 hov-text-primary animate-underline-primary"
                                    href="<?php echo e(route('customer.products')); ?>"><?php echo e(translate('View All Products')); ?></a>
                            </div>
                        </div>
                        <div class="d-sm-flex bg-white pb-3 pb-md-4">
                            <!-- Banner -->
                            <?php
                                $classifiedBannerImage = get_setting('classified_banner_image_small', null, $lang);
                            ?>
                            <div class="px-3 px-sm-4">
                                <div class="w-sm-270px h-320px mx-auto">
                                    <a href="<?php echo e(route('customer.products')); ?>" class="d-block h-100 w-100 w-xl-auto hov-scale-img overflow-hidden">
                                        <img src="<?php echo e(uploaded_asset($classifiedBannerImage)); ?>"
                                            alt="<?php echo e(translate('Classified Ads')); ?>"
                                            class="img-fit h-100 has-transition"
                                            onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                    </a>
                                </div>
                            </div>
                            <!-- Products -->
                            <div class="px-0 px-sm-4 w-100 overflow-hidden">
                                <div class="aiz-carousel arrow-x-0 arrow-inactive-none" data-items="5"
                                    data-xxl-items="5" data-xl-items="3.5" data-lg-items="3" data-md-items="2" data-sm-items="1"
                                    data-xs-items="2" data-arrows='true' data-infinite='false'>
                                    <?php $__currentLoopData = $classified_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $classified_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="px-3">
                                            <a href="<?php echo e(route('customer.product', $classified_product->slug)); ?>"
                                                class="d-block overflow-hidden h-140px h-md-170px text-center hov-scale-img mb-3">
                                                <img class="img-fluid lazyload mx-auto has-transition"
                                                    src="<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>"
                                                    data-src="<?php echo e(isset($classified_product->thumbnail->file_name) ? my_asset($classified_product->thumbnail->file_name) : static_asset('assets/img/placeholder.jpg')); ?>"
                                                    alt="<?php echo e($classified_product->getTranslation('name')); ?>"
                                                    onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                                            </a>
                                            <h3
                                                class="fw-400 fs-14 text-dark text-truncate-2 lh-1-4 mb-3 h-35px d-none d-sm-block">
                                                <a href="<?php echo e(route('customer.product', $classified_product->slug)); ?>"
                                                    class="d-block text-reset hov-text-primary"><?php echo e($classified_product->getTranslation('name')); ?></a>
                                            </h3>
                                            <div class="fs-14 mb-3">
                                                <span
                                                    class="text-secondary"><?php echo e($classified_product->user ? $classified_product->user->name : ''); ?></span><br>
                                                <span
                                                    class="fw-700 text-primary"><?php echo e(single_price($classified_product->unit_price)); ?></span>
                                            </div>
                                            <?php if($classified_product->conditon == 'new'): ?>
                                                <span
                                                    class="badge badge-inline badge-soft-info fs-13 fw-700 px-3 py-2 text-info"
                                                    style="border-radius: 20px;"><?php echo e(translate('New')); ?></span>
                                            <?php elseif($classified_product->conditon == 'used'): ?>
                                                <span
                                                    class="badge badge-inline badge-soft-secondary-base fs-13 fw-700 px-3 py-2 text-danger"
                                                    style="border-radius: 20px;"><?php echo e(translate('Used')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php endif; ?>
    <?php endif; ?>
    <?php if(addon_is_activated('preorder')): ?>
    <!-- Newest Preorder Products -->
        <?php echo $__env->make('preorder.frontend.home_page.newest_preorder', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <!-- Category wise Products -->
    <div id="section_home_categories">

    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/goldqurosh/public_html/resources/views/frontend/megamart/index.blade.php ENDPATH**/ ?>